/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.server.IRemoteHostProvider;
import ch.systemsx.cisd.lims.server.business.Session;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoginLogManager {
    public static final String LOGOUT_PREFIX = "LOGOUT: ";
    public static final String LOGIN_PREFIX = "LOGIN: ";
    private final Logger operationExAuthenticationLog;
    private final IRemoteHostProvider remoteHostProvider;

    public LoginLogManager(Class<?> clazz, IRemoteHostProvider remoteHostProvider) {
        this.operationExAuthenticationLog = LogFactory.getLogger(LogCategory.OPERATION, clazz);
        this.remoteHostProvider = remoteHostProvider;
    }

    public final Logger getAuthenticationLog() {
        return this.operationExAuthenticationLog;
    }

    public final void logCreateSessionFailure(String user, RuntimeException ex) {
        this.operationExAuthenticationLog.error("LOGIN: Error when trying to authenticate user '" + user + "'.", ex);
    }

    public final void logAttemptCreateSession(String user, boolean isAuthenticated, String sessionToken) {
        if (isAuthenticated) {
            if (this.operationExAuthenticationLog.isInfoEnabled()) {
                this.operationExAuthenticationLog.info("LOGIN: User '" + user + "' has been successfully authenticated from host '" + this.remoteHostProvider.getRemoteHost() + "'. Session token: '" + sessionToken + "'.");
            }
        } else {
            this.operationExAuthenticationLog.warn("LOGIN: User '" + user + "' failed to authenticate from host '" + this.remoteHostProvider.getRemoteHost() + "'.");
        }
    }

    public final void logAttemptCloseSession(String sessionToken, Session session) {
        if (session != null) {
            if (this.operationExAuthenticationLog.isInfoEnabled()) {
                String user = session.getUserName();
                this.operationExAuthenticationLog.info("LOGOUT: Session '" + sessionToken + "' of user '" + user + "' has been closed from host '" + this.remoteHostProvider.getRemoteHost() + "'.");
            }
        } else {
            this.operationExAuthenticationLog.warn("LOGOUT: Attempt to close non-existent session '" + sessionToken + "' from host '" + this.remoteHostProvider.getRemoteHost() + "'.");
        }
    }
}

