/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.lims.server.business.AbstractManager;
import ch.systemsx.cisd.lims.server.business.IPersonManager;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.StrategyFactoryProvider;
import ch.systemsx.cisd.lims.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.lims.server.business.bo.IPersonBO;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dto.PersonDTO;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PersonManager
extends AbstractManager
implements IPersonManager {
    PersonManager(IDAOFactory daoFactory, StrategyFactoryProvider strategyProvider, IBusinessObjectFactory boFactory) {
        super(daoFactory, strategyProvider, boFactory);
    }

    @Override
    @Transactional
    public final List<PersonDTO> listPersons() {
        return this.daoFactory.getPersonDAO().listPersons();
    }

    @Override
    @Transactional
    public final void registerPerson(Session session) {
        assert (session != null);
        IPersonBO personBO = this.boFactory.createPersonBO(session);
        personBO.define();
        personBO.save();
    }

    @Override
    @Transactional
    public final PersonDTO getPerson(Session session) {
        assert (session != null);
        IPersonBO personBO = this.boFactory.createPersonBO(session);
        personBO.load();
        return personBO.getPerson();
    }
}

