/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.lims.server.business.AbstractManager;
import ch.systemsx.cisd.lims.server.business.IProjectManager;
import ch.systemsx.cisd.lims.server.business.ParameterChecker;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.StrategyFactoryProvider;
import ch.systemsx.cisd.lims.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.lims.server.business.bo.IProjectBO;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dto.ProjectDTO;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProjectManager
extends AbstractManager
implements IProjectManager {
    ProjectManager(IDAOFactory daoFactory, StrategyFactoryProvider strategyProvider, IBusinessObjectFactory boFactory) {
        super(daoFactory, strategyProvider, boFactory);
    }

    @Override
    @Transactional
    public final List<ProjectDTO> listProjects(long groupId) {
        return this.daoFactory.getProjectDAO().listProjects(groupId);
    }

    @Override
    @Transactional
    public final void registerProject(Session session, String projectCode) {
        assert (session != null);
        ParameterChecker.checkIfNotNull(projectCode, "project");
        IProjectBO projectBO = this.boFactory.createProjectBO(session);
        projectBO.define(projectCode);
        projectBO.save();
    }
}

