/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.server.business.ParameterChecker;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractSampleBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.IBasicSampleBO;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.lims.server.dto.ProcedureDTO;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;

public class BasicSampleBO
extends AbstractSampleBusinessObject
implements IBasicSampleBO {
    private static final Logger operationExTrackingLog = LogFactory.getLogger(LogCategory.OPERATION, BasicSampleBO.class);
    protected SampleDTO sample;
    protected boolean dataChanged = false;

    public BasicSampleBO(IDAOFactory daoFactory, Session session) {
        super(daoFactory, session);
    }

    private final void loadBySampleCode(String sampleCode, boolean withProcExpProj) {
        ParameterChecker.checkIfNotNull(sampleCode, "sample code");
        this.sample = this.getSampleDAO().tryFindSampleByCode(sampleCode);
        if (this.sample == null) {
            throw UserFailureException.fromTemplate("No sample with code '%s' could be found in the database.", sampleCode);
        }
        if (withProcExpProj) {
            this.enrichWithProcedure();
        }
    }

    private final void enrichWithProcedure() {
        List<ProcedureDTO> procedures = this.getProcedureDAO().listProceduresWithExp(this.sample.getId(), this.session.getGroupId());
        if (procedures.size() == 0) {
            return;
        }
        this.enrichWithProcedure(this.sample, procedures);
    }

    private final void logAddingSampleForProc(Long procedureIdOrNull) {
        if (operationExTrackingLog.isInfoEnabled()) {
            if (procedureIdOrNull != null) {
                operationExTrackingLog.info("ADD: sample '" + this.sample + "' for procedure id '" + procedureIdOrNull + "'.");
            } else {
                operationExTrackingLog.info("ADD: sample '" + this.sample + "' (not associated with any procedure).");
            }
        }
    }

    public final boolean containsSampleCode(String sampleCode) {
        return this.getSampleDAO().tryFindSampleIdByCode(sampleCode) != null;
    }

    public final SampleDTO getSample() {
        if (this.sample == null) {
            throw new UserFailureException("Undefined sample.");
        }
        return this.sample;
    }

    public final void loadSimpleBySampleCode(String sampleCode) {
        this.loadBySampleCode(sampleCode, false);
    }

    public final void loadBySampleCode(String sampleCode) {
        this.loadBySampleCode(sampleCode, true);
    }

    public final void save() {
        assert (this.sample != null) : "Sample not loaded.";
        assert (this.dataChanged) : "Data have not been changed.";
        try {
            ISampleDAO sampleDAO = this.getSampleDAO();
            sampleDAO.createSample(this.sample);
            this.getEntityPropertyTypeDAO(EntityKind.SAMPLE).createProperties(this.sample);
            Long procedureIDOrNull = this.sample.getProcedureID();
            if (procedureIDOrNull != null) {
                sampleDAO.createSampleInput(this.sample.getId(), procedureIDOrNull);
            }
            this.logAddingSampleForProc(procedureIDOrNull);
        }
        catch (DataAccessException ex) {
            BasicSampleBO.throwException(ex, String.format("Sample '%s'", this.sample.getCode()));
        }
        this.dataChanged = false;
    }
}

