/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.EntityPropertyFiller;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.IEntityPropertiesBO;
import ch.systemsx.cisd.lims.server.business.bo.IKey;
import ch.systemsx.cisd.lims.server.business.bo.IPropertyValueProvider;
import ch.systemsx.cisd.lims.server.business.bo.IPropertyValueProviderFactory;
import ch.systemsx.cisd.lims.server.business.bo.PropertyTypeAssignmentStatus;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IPropertyTypeDAO;
import ch.systemsx.cisd.lims.server.dto.EntityPropertyTypeAssignmentDTO;
import ch.systemsx.cisd.lims.server.dto.EntityPropertyValueDTO;
import ch.systemsx.cisd.lims.server.dto.EntityTypeDTO;
import ch.systemsx.cisd.lims.server.dto.ICodeAndIDHolder;
import ch.systemsx.cisd.lims.server.dto.PropertyTypeDTO;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EntityPropertiesBO
extends AbstractBusinessObject
implements IEntityPropertiesBO {
    private final EntityKind entityKind;
    private final IEntityTypeDAO entityTypeDAO;
    private final IEntityPropertyTypeDAO entityPropertyTypeDAO;
    private final IPropertyValueProviderFactory valueProviderFactory;
    private PropertyTypeAssignmentStatus assignmentStatus;
    private Set<IKey> unmatchedValues;
    private Set<IKey> missingEntities;

    EntityPropertiesBO(EntityKind entityKind, IDAOFactory daoFactory, Session session, IPropertyValueProviderFactory valueProviderFactory) {
        super(daoFactory, session);
        this.entityKind = entityKind;
        this.valueProviderFactory = valueProviderFactory;
        this.entityPropertyTypeDAO = this.getEntityPropertyTypeDAO(entityKind);
        this.entityTypeDAO = this.getEntityTypeDAO(entityKind);
        this.missingEntities = EntityPropertiesBO.createEmptyKeySet();
        this.unmatchedValues = EntityPropertiesBO.createEmptyKeySet();
    }

    private static TreeSet<IKey> createEmptyKeySet() {
        return new TreeSet<IKey>(IKey.KEY_COMPARATOR);
    }

    private void createPropertyValues(Long entityTypeID, PropertyTypeDTO propertyType, EntityPropertyTypeAssignmentDTO assignment, String untypedDefaultValueOrNull, EntityPropertyFiller[] filler) {
        long groupID = this.session.getGroupId();
        IPropertyValueProvider provider = this.valueProviderFactory.create(this.entityKind, groupID, propertyType, untypedDefaultValueOrNull, filler);
        Long assignmentID = assignment.getId();
        List<ICodeAndIDHolder> list = this.entityPropertyTypeDAO.listEntitiesWithMissingPropertyValues(entityTypeID, assignmentID);
        for (ICodeAndIDHolder codeAndIDHolder : list) {
            EntityPropertyValueDTO propertyValue = new EntityPropertyValueDTO(this.findRegistratorID(), assignmentID);
            boolean successful = provider.attemptToSetUntypedValue(propertyValue, codeAndIDHolder);
            if (successful) {
                this.entityPropertyTypeDAO.createPropertyValue(codeAndIDHolder.getId(), propertyValue);
                continue;
            }
            this.missingEntities.add(provider.getKey(codeAndIDHolder));
        }
        this.unmatchedValues = provider.getUnmatchedValues();
    }

    private PropertyTypeDTO getPropertyTypeByCode(IPropertyTypeDAO propertyTypeDAO, String propertyTypeCode) {
        PropertyTypeDTO propertyTypeOrNull = propertyTypeDAO.tryGetPropertyTypeByCode(propertyTypeCode);
        if (propertyTypeOrNull == null) {
            String message = String.format("Property type with the name '%s' does not exist!", propertyTypeCode);
            throw new UserFailureException(message);
        }
        return propertyTypeOrNull;
    }

    @Override
    public final void createAssignmentAndPropertyValues(String entityTypeCode, String propertyTypeCode, boolean mandatory, String untypedDefaultValueOrNull, EntityPropertyFiller[] fillers) {
        Long entityTypeID = this.getEntityTypeId(entityTypeCode);
        IPropertyTypeDAO propertyTypeDAO = this.getPropertyTypeDAO();
        PropertyTypeDTO propertyType = this.getPropertyTypeByCode(propertyTypeDAO, propertyTypeCode);
        EntityPropertyTypeAssignmentDTO assignment = this.entityPropertyTypeDAO.tryFindAssignment(entityTypeID, propertyType.getId());
        if (assignment == null) {
            if (propertyType.isManagedInternally()) {
                this.assignmentStatus = PropertyTypeAssignmentStatus.INTERNALLY_MANAGED_PROPERTY_TYPE_ERROR;
            } else {
                assignment = this.createAssignment(mandatory, entityTypeID, propertyType);
                this.assignmentStatus = PropertyTypeAssignmentStatus.PROPERTY_ASSIGNED;
            }
        } else {
            this.assignmentStatus = this.updateAssignment(mandatory, assignment);
        }
        if (EntityPropertiesBO.canInsertPropertyValues(this.assignmentStatus)) {
            this.createPropertyValues(entityTypeID, propertyType, assignment, untypedDefaultValueOrNull, fillers);
        }
    }

    private static boolean canInsertPropertyValues(PropertyTypeAssignmentStatus assignmentStatus) {
        return assignmentStatus != PropertyTypeAssignmentStatus.INTERNALLY_MANAGED_ASSIGNMENT_UPDATE_ERROR && assignmentStatus != PropertyTypeAssignmentStatus.INTERNALLY_MANAGED_PROPERTY_TYPE_ERROR;
    }

    private EntityPropertyTypeAssignmentDTO createAssignment(boolean mandatory, Long entityTypeID, PropertyTypeDTO propertyType) {
        Long id = this.findRegistratorID();
        EntityPropertyTypeAssignmentDTO assignment = new EntityPropertyTypeAssignmentDTO(id, entityTypeID, propertyType.getId());
        assignment.setMandatory(mandatory);
        this.entityPropertyTypeDAO.createEntityPropertyTypeAssignment(assignment);
        return assignment;
    }

    private PropertyTypeAssignmentStatus updateAssignment(boolean mandatory, EntityPropertyTypeAssignmentDTO assignment) {
        if (assignment.isMandatory() == mandatory) {
            return PropertyTypeAssignmentStatus.EXACTLY_SAME_ASSIGNMENT_EXISTS;
        }
        if (assignment.isManagedInternally()) {
            return PropertyTypeAssignmentStatus.INTERNALLY_MANAGED_ASSIGNMENT_UPDATE_ERROR;
        }
        this.entityPropertyTypeDAO.updateMandatoryFlag(assignment.getId(), mandatory);
        return PropertyTypeAssignmentStatus.MANDATORY_FLAG_CHANGED;
    }

    private Long getEntityTypeId(String entityTypeCode) {
        EntityTypeDTO entityType = this.entityTypeDAO.tryToFindEntityTypeByCode(entityTypeCode);
        if (entityType == null) {
            String entityKindLabel = this.entityKind.getLabel();
            throw UserFailureException.fromTemplate("Invalid %s type code '%s'. It does not exist!", entityKindLabel, entityTypeCode);
        }
        Long entityTypeID = entityType.getId();
        return entityTypeID;
    }

    @Override
    public final Set<IKey> getMissingEntities() {
        return this.missingEntities;
    }

    @Override
    public final Set<IKey> getUnmatchedValues() {
        return this.unmatchedValues;
    }

    @Override
    public final PropertyTypeAssignmentStatus getAssignmentStatus() {
        return this.assignmentStatus;
    }
}

