/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.IEntityPropertyTypeTable;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityPropertyTypeDAO;
import ch.systemsx.cisd.lims.server.dto.EntityPropertyTypeAssignmentDTO;
import ch.systemsx.cisd.lims.server.dto.EntityTypeDTO;
import ch.systemsx.cisd.lims.server.dto.PropertyTypeDTO;
import ch.systemsx.cisd.lims.server.util.KeyExtractorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityPropertyTypeTable
extends AbstractBusinessObject
implements IEntityPropertyTypeTable {
    private static final List<EntityPropertyTypeAssignmentDTO> EMPTY_LIST = Collections.emptyList();
    private final Map<String, List<EntityPropertyTypeAssignmentDTO>> propertyTypeToRelationMap = new LinkedHashMap<String, List<EntityPropertyTypeAssignmentDTO>>();
    private List<EntityPropertyTypeAssignmentDTO> relations = EMPTY_LIST;

    public EntityPropertyTypeTable(IDAOFactory daoFactory, Session session) {
        super(daoFactory, session);
    }

    private TableMap<Long, EntityTypeDTO> loadTypeTable(EntityKind entityKind) {
        List<EntityTypeDTO> types = this.getEntityTypeDAO(entityKind).listEntityTypes();
        TableMap<Long, EntityTypeDTO> table = new TableMap<Long, EntityTypeDTO>(types, KeyExtractorFactory.getEntityTypeByIdKeyExtractor());
        return table;
    }

    @Override
    public void loadRelations(EntityKind entityKind) {
        this.propertyTypeToRelationMap.clear();
        TableMap<Long, EntityTypeDTO> typeTable = this.loadTypeTable(entityKind);
        List<PropertyTypeDTO> propertyTypes = this.getPropertyTypeDAO().listPropertyTypes();
        TableMap<Long, PropertyTypeDTO> propertyTapeTable = new TableMap<Long, PropertyTypeDTO>(propertyTypes, KeyExtractorFactory.getPropertyTypeByIdKeyExtractor());
        IEntityPropertyTypeDAO entityPropertyTypeDAO = this.getEntityPropertyTypeDAO(entityKind);
        this.relations = entityPropertyTypeDAO.listEntityPropertyTypeRelations();
        for (EntityPropertyTypeAssignmentDTO relation : this.relations) {
            EntityTypeDTO entityTypeDTO = typeTable.tryGet(relation.getEntityTypeID());
            if (entityTypeDTO == null) {
                throw new IllegalStateException("No entity type for id=" + relation.getEntityTypeID());
            }
            relation.setEntityType(entityTypeDTO);
            PropertyTypeDTO propertyType = propertyTapeTable.tryGet(relation.getPropertyTypeID());
            if (propertyType == null) {
                throw new IllegalStateException("No property type for id=" + relation.getPropertyTypeID());
            }
            relation.setPropertyType(propertyType);
            List<EntityPropertyTypeAssignmentDTO> list = this.propertyTypeToRelationMap.get(propertyType.getCode());
            if (list == null) {
                list = new ArrayList<EntityPropertyTypeAssignmentDTO>();
                this.propertyTypeToRelationMap.put(propertyType.getCode(), list);
            }
            list.add(relation);
        }
    }

    @Override
    public List<EntityPropertyTypeAssignmentDTO> getRelationsFor(String propertyName) {
        List<EntityPropertyTypeAssignmentDTO> list = this.propertyTypeToRelationMap.get(propertyName);
        return list == null ? EMPTY_LIST : list;
    }

    @Override
    public void save() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<EntityPropertyTypeAssignmentDTO> iterator() {
        return this.relations.iterator();
    }
}

