/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.lims.base.TimeInterval;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.EntityPropertyFiller;
import ch.systemsx.cisd.lims.server.business.bo.IExperimentTable;
import ch.systemsx.cisd.lims.server.business.bo.RegistratorFiller;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityPropertyProviderDAO;
import ch.systemsx.cisd.lims.server.dto.BaseExperimentDTO;
import ch.systemsx.cisd.lims.server.dto.ExperimentTypeDTO;
import ch.systemsx.cisd.lims.server.dto.ProjectDTO;
import ch.systemsx.cisd.lims.server.util.KeyExtractorFactory;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExperimentTable
extends AbstractBusinessObject
implements IExperimentTable {
    private List<BaseExperimentDTO> experiments;

    ExperimentTable(IDAOFactory daoFactory, Session session) {
        super(daoFactory, session);
    }

    @Override
    public final void load(String experimentTypeCodeOrNull, boolean suppressInvalid) {
        if (experimentTypeCodeOrNull != null) {
            long experimentTypeId = this.getExperimentTypeDAO().getExperimentTypeIdByCode(experimentTypeCodeOrNull);
            this.experiments = this.getExperimentDAO().listBaseExperiments(this.session.getGroupId(), experimentTypeId, suppressInvalid);
        } else {
            this.experiments = this.getExperimentDAO().listBaseExperiments(this.session.getGroupId(), suppressInvalid);
        }
    }

    @Override
    public final void filterBy(Long projectIDOrNull, Long studyObjectIDOrNull, TimeInterval timeIntervalOrNull) {
        if (this.experiments != null) {
            Iterator<BaseExperimentDTO> iter = this.experiments.iterator();
            while (iter.hasNext()) {
                Date lastDataSetDate;
                Date registrationDate;
                TimeInterval activeTimeInterval;
                BaseExperimentDTO experiment = iter.next();
                if (projectIDOrNull != null && !projectIDOrNull.equals(experiment.getProjectID())) {
                    iter.remove();
                    continue;
                }
                if (studyObjectIDOrNull != null && !studyObjectIDOrNull.equals(experiment.getStudyObjectID())) {
                    iter.remove();
                    continue;
                }
                if (timeIntervalOrNull == null || timeIntervalOrNull.overlapsWith(activeTimeInterval = new TimeInterval(registrationDate = experiment.getRegistrationDate(), (lastDataSetDate = experiment.getLastDataSetDate()) == null ? registrationDate : lastDataSetDate))) continue;
                iter.remove();
            }
        }
    }

    @Override
    public final void enrichWithProjectAndGroup() {
        if (this.experiments != null) {
            List<ProjectDTO> projects = this.getProjectDAO().listProjects(this.session.getGroupId());
            TableMap<Long, ProjectDTO> projectsByID = new TableMap<Long, ProjectDTO>(projects, KeyExtractorFactory.getProjectByIdKeyExtractor());
            for (BaseExperimentDTO experiment : this.experiments) {
                Long projectID = experiment.getProjectID();
                assert (projectID != null) : String.format("No project id specified for experiment code '%s'.", experiment.getCode());
                ProjectDTO project = projectsByID.tryGet(projectID);
                assert (project != null) : String.format("No project found for id '%d'.", projectID);
                experiment.setProject(project);
            }
        }
    }

    @Override
    public final void enrichWithRegistrator() {
        if (this.experiments != null) {
            RegistratorFiller.fillRegistratorsFor(this.experiments, this.getPersonDAO());
        }
    }

    @Override
    public final void enrichWithStudyObject() {
        if (this.experiments != null) {
            for (BaseExperimentDTO experiment : this.experiments) {
                Long studyObjectID = experiment.getStudyObjectID();
                if (studyObjectID == null) continue;
                experiment.setStudyObject(this.getMaterialDAO().getMaterialById(studyObjectID));
            }
        }
    }

    @Override
    public final void save() {
        throw new UnsupportedOperationException("Experiment table can not be saved.");
    }

    @Override
    public final Iterator<BaseExperimentDTO> iterator() {
        return this.experiments == null ? Collections.emptyList().iterator() : this.experiments.iterator();
    }

    @Override
    public final void enrichWithProperties() {
        if (this.experiments != null) {
            EntityPropertyFiller.fillPropertyFor(this.experiments, (IEntityPropertyProviderDAO)this.getExperimentDAO());
        }
    }

    @Override
    public final void enrichWithTypes() {
        List<ExperimentTypeDTO> types = this.getExperimentTypeDAO().listExperimentTypes();
        for (ExperimentTypeDTO type : types) {
            for (BaseExperimentDTO experiment : this.experiments) {
                if (!experiment.getExperimentTypeID().equals(type.getId())) continue;
                experiment.setExperimentType(type);
            }
        }
    }

    @Override
    public final List<BaseExperimentDTO> getBaseExperiments() {
        assert (this.experiments != null) : "Experiments have not been loaded.";
        return this.experiments;
    }
}

