/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ExternalData;
import ch.systemsx.cisd.lims.base.FileFormatType;
import ch.systemsx.cisd.lims.base.LocatorType;
import ch.systemsx.cisd.lims.base.ObservableType;
import ch.systemsx.cisd.lims.base.ProcedureTypeCode;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.IExternalDataBO;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IExternalDataDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IProcedureDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IProcedureTypeDAO;
import ch.systemsx.cisd.lims.server.dto.DataDTO;
import ch.systemsx.cisd.lims.server.dto.ExternalDataDTO;
import ch.systemsx.cisd.lims.server.dto.FileFormatTypeDTO;
import ch.systemsx.cisd.lims.server.dto.ObservableTypeDTO;
import ch.systemsx.cisd.lims.server.dto.ProcedureDTO;
import ch.systemsx.cisd.lims.server.dto.ProcedureTypeDTO;
import org.apache.commons.io.FilenameUtils;
import org.springframework.dao.DataAccessException;

final class ExternalDataBO
extends AbstractBusinessObject
implements IExternalDataBO {
    private ExternalDataDTO externalData;
    private Long sampleId;
    private IExternalDataDAO.SourceType sourceType;
    boolean dataChanged;

    ExternalDataBO(IDAOFactory daoFactory, Session session) {
        super(daoFactory, session);
    }

    private final ObservableTypeDTO getObservableType(ObservableType observableType) {
        String observableTypeCode = observableType.getCode();
        ObservableTypeDTO observableTypeOrNull = this.getObservableTypeDAO().tryFindObservableTypeByCode(observableTypeCode);
        if (observableTypeOrNull == null) {
            throw UserFailureException.fromTemplate("There is no observable type with code '%s'", observableTypeCode);
        }
        return observableTypeOrNull;
    }

    private final FileFormatTypeDTO getFileFomatType(FileFormatType fileFormatType) {
        String fileFormatTypeCode = fileFormatType.getCode();
        FileFormatTypeDTO fileFormatTypeOrNull = this.getFileFormatTypeDAO().tryFindFileFormatTypeByCode(fileFormatTypeCode);
        if (fileFormatTypeOrNull == null) {
            throw UserFailureException.fromTemplate("There is no file format type with code '%s'", fileFormatTypeCode);
        }
        return fileFormatTypeOrNull;
    }

    private final ProcedureDTO getOrCreateUnknownProcedure(long experimentId) {
        IProcedureDAO procedureDAO = this.getProcedureDAO();
        ProcedureDTO procedure = procedureDAO.tryGetProcedure(ProcedureTypeCode.UNKNOWN.getCode(), experimentId);
        if (procedure == null) {
            procedure = new ProcedureDTO(experimentId);
            IProcedureTypeDAO procedureTypeDAO = this.getProcedureTypeDAO();
            String code = ProcedureTypeCode.UNKNOWN.getCode();
            ProcedureTypeDTO procedureTypeDTO = procedureTypeDAO.tryFindProcedureTypeByCode(code);
            procedure.setProcedureType(procedureTypeDTO);
            procedureDAO.createProcedure(procedure);
        }
        return procedure;
    }

    public final void define(ExternalData data, long procedureID, Long sampleIdOrNull, IExternalDataDAO.SourceType aSourceType) {
        assert (data != null) : "Undefined data.";
        ObservableType observableType = data.getObservableType();
        assert (observableType != null) : "Undefined observable type.";
        FileFormatType fileFormatType = data.getFileFormatType();
        assert (fileFormatType != null) : "Undefined file format type.";
        String location = data.getLocation();
        assert (location != null) : "Undefined location.";
        LocatorType locatorType = data.getLocatorType();
        assert (locatorType != null) : "Undefined location type.";
        assert (aSourceType != null) : "Undefined source type.";
        this.sampleId = sampleIdOrNull;
        this.sourceType = aSourceType;
        this.externalData = new ExternalDataDTO(procedureID);
        this.externalData.setDataProducerCode(data.getDataProducerCode());
        this.externalData.setProductionDate(data.getProductionDate());
        this.externalData.setCode(data.getCode());
        this.externalData.setObservableType(this.getObservableType(observableType));
        this.externalData.setFileFormatType(this.getFileFomatType(fileFormatType));
        this.externalData.setComplete(data.getComplete());
        if (FilenameUtils.getPrefixLength((String)location) > 0) {
            throw UserFailureException.fromTemplate("Given relative data set path '%s' is not relative.", location);
        }
        this.externalData.setLocation(location);
        this.externalData.setStorageFormat(data.getStorageFormat());
        this.externalData.setLocatorType(this.getLocatorTypeDAO().tryFindLocatorTypeByCode(locatorType.getCode()));
        this.dataChanged = true;
    }

    public final void linkToParent(String parentDataSetCode, long experimentId) {
        long parentDataSetId;
        assert (parentDataSetCode != null) : "Unspecified parent data set code.";
        assert (this.externalData != null) : "Undefined external data.";
        assert (this.externalData.getId() != null) : "Unspecified external data id (not saved?).";
        IExternalDataDAO externalDataDAO = this.getExternalDataDAO();
        DataDTO parentData = externalDataDAO.tryGetData(parentDataSetCode);
        if (parentData == null) {
            ProcedureDTO procedure = this.getOrCreateUnknownProcedure(experimentId);
            parentDataSetId = externalDataDAO.createPlaceholderData(parentDataSetCode, procedure.getId(), this.sampleId);
        } else {
            parentDataSetId = parentData.getId();
        }
        externalDataDAO.createDataSetRelationship(parentDataSetId, this.externalData.getId());
    }

    public final ExternalDataDTO getExternalData() {
        assert (this.externalData != null) : "Undefined external data.";
        return this.externalData;
    }

    public final void save() {
        if (this.dataChanged) {
            try {
                DataDTO data;
                IExternalDataDAO externalDataDAO = this.getExternalDataDAO();
                String dataCode = this.externalData.getCode();
                if (dataCode != null && (data = externalDataDAO.tryGetData(dataCode)) != null) {
                    if (!data.isPlaceholder()) {
                        throw new UserFailureException("Already existing data set for code '" + dataCode + "' can not be updated by data set " + this.externalData);
                    }
                    externalDataDAO.updateExternalData(this.externalData, this.sampleId, this.sourceType);
                    this.dataChanged = false;
                    return;
                }
                externalDataDAO.createExternalData(this.externalData, this.sampleId, this.sourceType);
                this.dataChanged = false;
            }
            catch (DataAccessException ex) {
                ExternalDataBO.throwException(ex, String.format("given relative path '%s'", this.externalData.getLocation()));
            }
        }
    }
}

