/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.collections.IKeyExtractor;
import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.lims.base.ProcessingInstruction;
import ch.systemsx.cisd.lims.base.ProcessingParameters;
import ch.systemsx.cisd.lims.server.business.IProcessingInstructionValidator;
import ch.systemsx.cisd.lims.server.business.ParameterChecker;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.IProcessingInstructionTable;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IExperimentAttachmentDAO;
import ch.systemsx.cisd.lims.server.dto.ExperimentFileAttachmentDTO;
import ch.systemsx.cisd.lims.server.dto.FilePropertyDTO;
import ch.systemsx.cisd.lims.server.dto.PersonDTO;
import ch.systemsx.cisd.lims.server.dto.ProcessingInstructionDTO;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessingInstructionTable
extends AbstractBusinessObject
implements IProcessingInstructionTable {
    private static final String PROCESSING_PATH = "$processing-path-for-";
    static final String PROCESSING_PATH_TEMPLATE = "$processing-path-for-%s";
    static final String PROCESSING_PARAMETERS_TEMPLATE = "$processing-parameters-for-%s";
    static final String PROCESSING_DESCRIPTION_TEMPLATE = "$processing-description-for-%s";
    static final String ENCODING = "utf-8";
    private static final IKeyExtractor<String, ProcessingInstructionDTO> KEY_EXTRACTOR = new IKeyExtractor<String, ProcessingInstructionDTO>(){

        @Override
        public final String getKey(ProcessingInstructionDTO instruction) {
            return instruction.getProcedureTypeCode();
        }
    };
    private TableMap<String, ProcessingInstructionDTO> processingInstructions;
    private boolean dataChanged;

    ProcessingInstructionTable(IDAOFactory daoFactory, Session session) {
        super(daoFactory, session);
    }

    @Override
    public final void fill(Long experimentID, ProcessingInstruction[] instructions, IProcessingInstructionValidator validator) {
        ArrayList<ProcessingInstructionDTO> instructionDTOs = new ArrayList<ProcessingInstructionDTO>();
        Long registratorID = this.findRegistratorID();
        ProcessingInstruction[] processingInstructionArray = instructions;
        int n = instructions.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessingInstruction instruction = processingInstructionArray[n2];
            ParameterChecker.checkProcedureTypeCode(instruction.getProcedureTypeCode());
            ProcessingInstructionDTO processingInstruction = new ProcessingInstructionDTO(registratorID);
            processingInstruction.setExperimentID(experimentID);
            BeanUtils.fillBean(ProcessingInstructionDTO.class, processingInstruction, instruction, new BeanUtils.Converter(){

                public final byte[] convertToParameters(ProcessingInstruction processing) {
                    ProcessingParameters parameters = processing.getParameters();
                    if (parameters == null) {
                        return null;
                    }
                    return parameters.convertToBinary();
                }
            });
            validator.assertValid(processingInstruction);
            instructionDTOs.add(processingInstruction);
            ++n2;
        }
        this.processingInstructions = new TableMap<String, ProcessingInstructionDTO>(instructionDTOs, KEY_EXTRACTOR);
        this.dataChanged = true;
    }

    @Override
    public final void loadByExperimentID(long experimentID) {
        ArrayList<ProcessingInstructionDTO> instructions = new ArrayList<ProcessingInstructionDTO>();
        IExperimentAttachmentDAO experimentPropertyDAO = this.getExperimentAttachmentDAO();
        List<FilePropertyDTO> attachments = experimentPropertyDAO.listExperimentAttachments(experimentID);
        for (FilePropertyDTO attachment : attachments) {
            String fileName = attachment.getFileName();
            if (!fileName.startsWith(PROCESSING_PATH)) continue;
            PersonDTO registrator = attachment.getRegistrator();
            ProcessingInstructionDTO processingInstruction = new ProcessingInstructionDTO(registrator.getId());
            BeanUtils.fillBean(ProcessingInstructionDTO.class, processingInstruction, attachment);
            processingInstruction.setProcedureTypeCode(fileName.substring(PROCESSING_PATH.length()));
            instructions.add(processingInstruction);
        }
        for (ProcessingInstructionDTO instruction : instructions) {
            String procedureType = instruction.getProcedureTypeCode();
            instruction.setPath(this.loadText(experimentID, PROCESSING_PATH_TEMPLATE, procedureType));
            instruction.setDescription(this.loadText(experimentID, PROCESSING_DESCRIPTION_TEMPLATE, procedureType));
            instruction.setParameters(this.load(experimentID, PROCESSING_PARAMETERS_TEMPLATE, procedureType));
        }
        this.processingInstructions = new TableMap<String, ProcessingInstructionDTO>(instructions, KEY_EXTRACTOR);
    }

    @Override
    public final Iterator<ProcessingInstructionDTO> iterator() {
        return this.processingInstructions == null ? Collections.emptyList().iterator() : this.processingInstructions.iterator();
    }

    @Override
    public final void save() throws UserFailureException {
        if (this.dataChanged) {
            for (ProcessingInstructionDTO processingInstruction : this.processingInstructions) {
                byte[] parameters;
                String path = processingInstruction.getPath();
                this.saveText(processingInstruction, PROCESSING_PATH_TEMPLATE, path);
                String description = processingInstruction.getDescription();
                if (description != null) {
                    this.saveText(processingInstruction, PROCESSING_DESCRIPTION_TEMPLATE, description);
                }
                if ((parameters = processingInstruction.getParameters()) == null) continue;
                this.save(processingInstruction, PROCESSING_PARAMETERS_TEMPLATE, parameters);
            }
            this.dataChanged = false;
        }
    }

    private final String createKey(String template, String procedureTypeCode) {
        return String.format(template, procedureTypeCode);
    }

    private final String createText(byte[] textBytes) {
        try {
            return textBytes == null ? null : new String(textBytes, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EnvironmentFailureException("Unsupported character encoding: utf-8");
        }
    }

    private final String loadText(long experimentID, String template, String procedureTypeCode) {
        byte[] value = this.load(experimentID, template, procedureTypeCode);
        return this.createText(value);
    }

    private final byte[] load(long experimentID, String template, String procedureTypeCode) {
        String key = this.createKey(template, procedureTypeCode);
        IExperimentAttachmentDAO experimentPropertyDAO = this.getExperimentAttachmentDAO();
        ExperimentFileAttachmentDTO attachment = experimentPropertyDAO.tryFindExpAttachmentByExpIdAndFileName(experimentID, key);
        return attachment == null ? null : attachment.getValue();
    }

    private final void saveText(ProcessingInstructionDTO processingInstruction, String template, String text) {
        try {
            this.save(processingInstruction, template, text.getBytes(ENCODING));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new EnvironmentFailureException("Unsupported character encoding: utf-8");
        }
    }

    private final void save(ProcessingInstructionDTO processingInstruction, String template, byte[] value) {
        try {
            Long experimentID = processingInstruction.getExperimentID();
            Long registratorID = processingInstruction.getRegistratorID();
            ExperimentFileAttachmentDTO experimentFileProperty = new ExperimentFileAttachmentDTO(registratorID);
            FilePropertyDTO fileProperty = new FilePropertyDTO();
            fileProperty.setFileName(this.createKey(template, processingInstruction.getProcedureTypeCode()));
            experimentFileProperty.setFileProperty(fileProperty);
            experimentFileProperty.setValue(value);
            this.getExperimentAttachmentDAO().createExperimentAttachment(experimentID, experimentFileProperty);
        }
        catch (DataAccessException ex) {
            ProcessingInstructionTable.throwException(ex, String.format("Processing instruction for experiment '%s'", processingInstruction.getExperimentID()));
        }
    }
}

