/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.IProjectBO;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dto.ProjectDTO;
import org.springframework.dao.DataAccessException;

class ProjectBO
extends AbstractBusinessObject
implements IProjectBO {
    private ProjectDTO project;

    ProjectBO(IDAOFactory daoFactory, Session session) {
        super(daoFactory, session);
    }

    public final void load(String projectCode) {
        assert (projectCode != null) : "Unspecified project code.";
        long groupId = this.session.getGroupId();
        Long projectId = this.getProjectDAO().tryFindProjectIdByCode(groupId, projectCode);
        if (projectId == null) {
            throw new UserFailureException("Unknown project '" + projectCode + "'.");
        }
        this.project = new ProjectDTO(groupId);
        this.project.setId(projectId);
    }

    public final void save() {
        assert (this.project != null) : "Can not save an undefined project.";
        try {
            this.getProjectDAO().createProject(this.project);
        }
        catch (DataAccessException ex) {
            ProjectBO.throwException(ex, String.format("Project '%s'", this.project.getCode()));
        }
    }

    public final void define(String projectCode) {
        assert (projectCode != null) : "Unspecified project code.";
        this.project = new ProjectDTO(this.session.getGroupId());
        this.project.setCode(projectCode);
    }

    public final ProjectDTO getProject() {
        return this.project;
    }
}

