/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.collections.IKeyExtractor;
import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.lims.server.dataaccess.IPersonDAO;
import ch.systemsx.cisd.lims.server.dto.IRegistratorHolder;
import ch.systemsx.cisd.lims.server.dto.PersonDTO;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RegistratorFiller {
    private RegistratorFiller() {
    }

    static final void fillRegistratorsFor(Iterable<? extends IRegistratorHolder> iterable, IPersonDAO personDAO) {
        assert (iterable != null) : "Given iterable can not be null.";
        assert (personDAO != null) : "Given personDAO can not be null.";
        List<PersonDTO> persons = personDAO.listPersons();
        if (persons.size() == 0) {
            return;
        }
        TableMap<Long, PersonDTO> table = new TableMap<Long, PersonDTO>(persons, new IKeyExtractor<Long, PersonDTO>(){

            @Override
            public final Long getKey(PersonDTO e) {
                return e.getId();
            }
        });
        for (IRegistratorHolder iRegistratorHolder : iterable) {
            if (iRegistratorHolder.getRegistrator() != null) continue;
            PersonDTO registrator = table.tryGet(iRegistratorHolder.getRegistratorID());
            assert (registrator != null) : "Registrator can not be null.";
            iRegistratorHolder.setRegistrator(registrator);
        }
    }
}

