/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.collections.IKeyExtractor;
import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.NewSampleComponent;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.ISampleComponentTable;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IMaterialBatchDAO;
import ch.systemsx.cisd.lims.server.dto.IEntityPropertiesHolderDTO;
import ch.systemsx.cisd.lims.server.dto.MaterialBatchDTO;
import ch.systemsx.cisd.lims.server.dto.MaterialDTO;
import ch.systemsx.cisd.lims.server.dto.SampleComponentDTO;
import ch.systemsx.cisd.lims.server.util.KeyExtractorFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SampleComponentTable
extends AbstractBusinessObject
implements ISampleComponentTable {
    private TableMap<String, SampleComponentDTO> sampleComponents;
    private TableMap<Long, MaterialDTO> materialsById;

    SampleComponentTable(IDAOFactory daoFactory, Session session) {
        super(daoFactory, session);
    }

    private final void createComponent(NewSampleComponent component, String materialBatchCode, Long sampleId) {
        MaterialBatchDTO materialBatchDTO = this.createMaterialBatch(component, materialBatchCode);
        SampleComponentDTO sampleComponentDTO = this.defineComponent(component, materialBatchDTO, sampleId);
        this.getSampleComponentDAO().createSampleComponent(sampleComponentDTO);
    }

    private final SampleComponentDTO defineComponent(NewSampleComponent component, MaterialBatchDTO materialBatchDTO, Long sampleId) {
        SampleComponentDTO sampleComponentDTO = new SampleComponentDTO();
        sampleComponentDTO.setMaterialBatch(materialBatchDTO);
        String code = component.getCode();
        sampleComponentDTO.setCode(code);
        sampleComponentDTO.setSampleID(sampleId);
        return sampleComponentDTO;
    }

    private final MaterialBatchDTO createMaterialBatch(NewSampleComponent component, String materialBatchCode) {
        String materialCode = component.getMaterialCode();
        String materialTypeCode = component.getMaterialTypeCode();
        Long registratorId = this.findRegistratorID();
        return this.findOrCreateMaterialBatch(materialCode, materialTypeCode, materialBatchCode, registratorId);
    }

    private final MaterialBatchDTO findOrCreateMaterialBatch(String materialCode, String materialTypeCode, String materialBatchCode, long registratorID) {
        MaterialBatchDTO materialBatch;
        long materialId = this.getMaterialId(materialCode, materialTypeCode);
        IMaterialBatchDAO materialBatchDAO = super.getMaterialBatchDAO();
        Long materialBatchId = materialBatchDAO.tryFindMaterialBatchIdByCode(materialBatchCode, materialId);
        if (materialBatchId == null) {
            materialBatch = new MaterialBatchDTO(registratorID);
            materialBatch.setCode(materialBatchCode);
            materialBatch.setMaterialID(materialId);
            materialBatchDAO.createMaterialBatch(materialBatch);
        } else {
            materialBatch = materialBatchDAO.getMaterialBatchForId(materialBatchId);
        }
        return materialBatch;
    }

    private final long getMaterialId(String materialCode, String materialTypeCode) throws UserFailureException {
        Long materialId = super.getMaterialDAO().tryFindMaterialIdByCodeAndTypeCode(materialCode, materialTypeCode);
        if (materialId == null) {
            throw UserFailureException.fromTemplate("No material with code '%s' and material type code '%s' could be found in the database.", materialCode, materialTypeCode);
        }
        return materialId;
    }

    private final void loadMaterialsOfType(String materialTypeCode) {
        this.materialsById = new TableMap<Long, MaterialDTO>(this.getMaterialDAO().listMaterials(materialTypeCode), KeyExtractorFactory.getMaterialByIdKeyExtractor());
    }

    @Override
    public final void loadBySampleID(long sampleID) {
        List<SampleComponentDTO> list = this.getSampleComponentDAO().listSampleComponents(sampleID);
        this.sampleComponents = new TableMap<String, SampleComponentDTO>(list, new IKeyExtractor<String, SampleComponentDTO>(){

            @Override
            public final String getKey(SampleComponentDTO e) {
                return e.getCode();
            }
        });
    }

    @Override
    public final List<String> getCodes() {
        ArrayList<String> list = new ArrayList<String>();
        for (SampleComponentDTO component : this.sampleComponents) {
            list.add(component.getCode());
        }
        return list;
    }

    @Override
    public final void save() {
        throw new UnsupportedOperationException("Sample Component table can not be saved.");
    }

    @Override
    public final Iterator<SampleComponentDTO> iterator() {
        return this.sampleComponents.iterator();
    }

    @Override
    public final void defineAndSave(NewSampleComponent[] components, String materialBatchCode, Long sampleId) {
        NewSampleComponent[] newSampleComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            NewSampleComponent component = newSampleComponentArray[n2];
            this.createComponent(component, materialBatchCode, sampleId);
            ++n2;
        }
    }

    @Override
    public final void enrichWithFullInhibitor() {
        if (this.sampleComponents != null) {
            this.loadMaterialsOfType("GENE");
            for (SampleComponentDTO component : this.sampleComponents) {
                MaterialDTO material = component.getMaterialBatch().getMaterial();
                Long inhibitorOfID = material.getInhibitorOfID();
                if (inhibitorOfID == null) continue;
                material.setInhibitorOf(this.materialsById.tryGet(inhibitorOfID));
            }
        }
    }

    @Override
    public final void enrichWithMaterialProperties() {
        if (this.sampleComponents != null) {
            TableMap<Long, IEntityPropertiesHolderDTO> propertiesHolderById = new TableMap<Long, IEntityPropertiesHolderDTO>(this.getMaterialDAO().listAllEntityProperties(), KeyExtractorFactory.getEntityPropertiesHolderKeyExtractor());
            for (SampleComponentDTO component : this.sampleComponents) {
                MaterialBatchDTO materialBatch = component.getMaterialBatch();
                assert (materialBatch != null) : String.format("Material batch must exist for component '%s'.", component);
                MaterialDTO material = materialBatch.getMaterial();
                assert (material != null) : String.format("Material must exist for component '%s'.", component);
                IEntityPropertiesHolderDTO propertiesHolder = propertiesHolderById.tryGet(material.getId());
                if (propertiesHolder == null) continue;
                material.setProperties(propertiesHolder.getProperties());
            }
        }
    }
}

