/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractSampleBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.EntityPropertyFiller;
import ch.systemsx.cisd.lims.server.business.bo.ISampleTable;
import ch.systemsx.cisd.lims.server.business.bo.SampleHierarchyFiller;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IEntityPropertyProviderDAO;
import ch.systemsx.cisd.lims.server.dataaccess.ISampleComponentDAO;
import ch.systemsx.cisd.lims.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.lims.server.dto.MaterialBatchDTO;
import ch.systemsx.cisd.lims.server.dto.MaterialDTO;
import ch.systemsx.cisd.lims.server.dto.PlateLocationDTO;
import ch.systemsx.cisd.lims.server.dto.ProcedureDTO;
import ch.systemsx.cisd.lims.server.dto.SampleComponentDTO;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import ch.systemsx.cisd.lims.server.util.KeyExtractorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SampleTable
extends AbstractSampleBusinessObject
implements ISampleTable {
    private List<SampleDTO> samples = new ArrayList<SampleDTO>();

    SampleTable(IDAOFactory daoFactory, Session session) {
        super(daoFactory, session);
    }

    private final Map<Long, PlateLocationDTO> createPlateLocations(Set<Long> topIds, Collection<MaterialDTO> inhibitors) {
        ISampleComponentDAO sampleComponentDAO = this.getSampleComponentDAO();
        ISampleDAO sampleDAO = this.getSampleDAO();
        HashMap<Long, PlateLocationDTO> map = new HashMap<Long, PlateLocationDTO>();
        for (Long topID : topIds) {
            ArrayList<SampleComponentDTO> matches = new ArrayList<SampleComponentDTO>();
            for (SampleComponentDTO componentDTO : sampleComponentDAO.listSampleComponents(topID)) {
                for (MaterialDTO inhibitor : inhibitors) {
                    MaterialBatchDTO materialBatch = componentDTO.getMaterialBatch();
                    if (materialBatch.getMaterial().getId().longValue() != inhibitor.getId().longValue()) continue;
                    matches.add(componentDTO);
                }
            }
            if (matches.size() <= 0) continue;
            String topSampleCode = sampleDAO.getSampleCodeById(topID);
            boolean masterPlateInvalidated = this.isSampleInvalidated(topSampleCode);
            PlateLocationDTO plateLocation = new PlateLocationDTO();
            plateLocation.setMasterPlateCode(topSampleCode);
            plateLocation.setMasterPlateInvalidated(masterPlateInvalidated);
            plateLocation.setSampleComponents(matches.toArray(new SampleComponentDTO[0]));
            map.put(topID, plateLocation);
        }
        return map;
    }

    private final boolean isSampleInvalidated(String sampleCode) {
        SampleDTO sample = this.getSampleDAO().tryFindSampleByCode(sampleCode);
        assert (sample != null) : "Top sample can not be null.";
        return sample.getInvalidation() != null;
    }

    private final void enrichWithProcedures() {
        TableMap<Long, ProcedureDTO> proceduresById = new TableMap<Long, ProcedureDTO>(this.getProcedureDAO().listSampleInputProcedures(), KeyExtractorFactory.getProcedureByIdKeyExtractor());
        TableMap<Long, SampleDTO> samplesById = new TableMap<Long, SampleDTO>(this.samples, KeyExtractorFactory.getSampleByIdKeyExtractor(), TableMap.UniqueKeyViolationStrategy.KEEP_FIRST);
        HashMap sampleIdsToProcedureList = new HashMap();
        for (SampleDTO sampleDTO : this.samples) {
            Long procedureID;
            Long sampleId = sampleDTO.getId();
            ArrayList<ProcedureDTO> procedures = (ArrayList<ProcedureDTO>)sampleIdsToProcedureList.get(sampleId);
            if (procedures == null) {
                procedures = new ArrayList<ProcedureDTO>();
                sampleIdsToProcedureList.put(sampleId, procedures);
            }
            if ((procedureID = sampleDTO.getProcedureID()) == null) continue;
            ProcedureDTO procedure = proceduresById.tryGet(procedureID);
            assert (procedure != null) : "Unspecified procedure.";
            procedures.add(procedure);
        }
        for (Map.Entry entry : sampleIdsToProcedureList.entrySet()) {
            List procedures = (List)entry.getValue();
            if (procedures.size() <= 0) continue;
            SampleDTO sample = samplesById.tryGet((Long)entry.getKey());
            sample.setProcedureID(null);
            this.enrichWithProcedure(sample, procedures);
        }
        this.samples = new ArrayList<SampleDTO>(samplesById.values());
    }

    @Override
    public final void addSamples(SampleDTO ... sample) {
        SampleDTO[] sampleDTOArray = sample;
        int n = sample.length;
        int n2 = 0;
        while (n2 < n) {
            SampleDTO sampleDTO = sampleDTOArray[n2];
            this.samples.add(sampleDTO);
            ++n2;
        }
    }

    @Override
    public final Collection<PlateLocationDTO> findPlateLocationsFor(Collection<MaterialDTO> molecules, boolean showInvalidated) {
        HashSet<Long> topIDs = new HashSet<Long>();
        for (SampleDTO sample : this.samples) {
            if (!showInvalidated && sample.getInvalidation() != null) continue;
            Long topID = sample.getTopID();
            assert (topID != null) : "Top id can not be null.";
            topIDs.add(topID);
        }
        Map<Long, PlateLocationDTO> map = this.createPlateLocations(topIDs, molecules);
        for (SampleDTO sample : this.samples) {
            Long opID;
            PlateLocationDTO plateLocation;
            if (!showInvalidated && sample.getInvalidation() != null || (plateLocation = map.get(opID = sample.getTopID())) == null) continue;
            plateLocation.addSample(sample);
        }
        return map.values();
    }

    @Override
    public final void save() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Iterator<SampleDTO> iterator() {
        return this.samples.iterator();
    }

    @Override
    public final List<SampleDTO> getSamples() {
        return new ArrayList<SampleDTO>(this.samples);
    }

    @Override
    public final void loadBySampleType(String sampleTypeCode, boolean enrichWithRelations) {
        ISampleDAO sampleDAO = this.getSampleDAO();
        Long sampleTypeId = this.getSampleType(sampleTypeCode).getId();
        if (enrichWithRelations) {
            this.samples = sampleDAO.listSamplesByType(sampleTypeId, this.session.getGroupId());
            this.enrichWithProcedures();
        } else {
            this.samples = sampleDAO.listSamplesByType(sampleTypeId);
        }
    }

    @Override
    public final void enrichParentAndTopWithInvalidation() {
        this.enrichParentAndTopWithInvalidation(this.samples.toArray(SampleDTO.EMPTY_ARRAY));
    }

    @Override
    public final void enrichWithProperties() {
        if (this.samples != null) {
            EntityPropertyFiller.fillPropertyFor(this.samples, (IEntityPropertyProviderDAO)this.getSampleDAO());
        }
    }

    @Override
    public final void enrichWithFullHierarchy() {
        SampleTable samplesToEnrich = this;
        SampleHierarchyFiller.enrichWithFullHierarchy(samplesToEnrich, this.getSampleDAO());
    }
}

