/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dataaccess.db.IDtoValidator;
import ch.systemsx.cisd.lims.server.dto.Id;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractDAO
extends SimpleJdbcDaoSupport {
    private final DtoValidatorStore dtoValidatorStore;
    protected final ISequencerHandler sequencerHandler;

    AbstractDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler) {
        this.dtoValidatorStore = dtoValidatorStore;
        this.sequencerHandler = sequencerHandler;
        this.setDataSource(dataSource);
    }

    protected final long getNextValueOf(String sequencer) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        return template.queryForLong(this.sequencerHandler.getNextValueScript(sequencer), new Object[0]);
    }

    protected final Long tryFindId(String sql, Object ... parameters) throws DataAccessException {
        assert (StringUtils.isNotBlank(sql)) : "Given sql can not be null.";
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List rows = template.query(sql, (ParameterizedRowMapper)new IdRowMapper(), parameters);
        int size = rows.size();
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return ((Id)rows.get(0)).getId();
            }
        }
        throw new IncorrectResultSizeDataAccessException("More than one entity for " + Arrays.asList(parameters) + " found: " + size, 1, size);
    }

    protected final String getCode(String sql, Object ... parameters) throws DataAccessException {
        assert (StringUtils.isNotBlank(sql)) : "Given sql can not be blank.";
        return (String)this.getSimpleJdbcTemplate().queryForObject(sql, (ParameterizedRowMapper)new CodeRowMapper(), parameters);
    }

    protected final void checkSizeIsOne(List<?> list, String objectType, long id) {
        int size = list.size();
        if (size == 0) {
            throw new EmptyResultDataAccessException("No " + objectType + " found with id " + id, 1);
        }
        if (size > 1) {
            throw new IncorrectResultSizeDataAccessException("More than one " + objectType + " for id " + id + " found: " + size, 1, size);
        }
    }

    protected final <E> void validateDTO(E dto) throws DataIntegrityViolationException {
        IDtoValidator<E> validator = this.dtoValidatorStore.getDTOValidator(dto);
        assert (validator != null) : String.format("No validator registered for class '%s'.", dto.getClass());
        validator.validate(dto);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CodeRowMapper
    implements ParameterizedRowMapper<String> {
        private CodeRowMapper() {
        }

        public String mapRow(ResultSet rs, int rowNum) throws SQLException {
            return rs.getString("code");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class IdRowMapper
    implements ParameterizedRowMapper<Id> {
        protected IdRowMapper() {
        }

        public final Id mapRow(ResultSet rs, int rowNum) throws SQLException {
            Id id = new Id(){};
            id.setId(rs.getLong("id"));
            return id;
        }
    }
}

