/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.utilities.Template;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dataaccess.db.properties.EntityPropertyTableNames;
import javax.sql.DataSource;

abstract class AbstractEntityDAO
extends AbstractDAO {
    protected final EntityPropertyTableNames entityPropertyTableNames;

    AbstractEntityDAO(EntityKind entityKind, DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler) {
        super(dataSource, dtoValidatorStore, sequencerHandler);
        this.entityPropertyTableNames = EntityPropertyTableNames.resolve(entityKind);
    }

    protected String createPropertiesSql(String sqlTemplate) {
        return this.createPropertiesRelatedSQLStatement(new Template(sqlTemplate));
    }

    protected String createPropertiesRelatedSQLStatement(Template sqlTemplate) {
        Template template = sqlTemplate.createFreshCopy();
        template.attemptToBind("entity_property", this.entityPropertyTableNames.getEntityPropertyTableName());
        template.attemptToBind("entity", this.entityPropertyTableNames.getEntityTableName());
        template.attemptToBind("entity_type", this.entityPropertyTableNames.getEntityTypeTableName());
        template.attemptToBind("entity_property_type", this.entityPropertyTableNames.getEntityPropertyTypeTableName());
        template.attemptToBind("fk_entity", this.entityPropertyTableNames.getEntityIDForeignKeyName());
        template.attemptToBind("fk_entity_type", this.entityPropertyTableNames.getEntityTypeIDForeignKeyName());
        template.attemptToBind("fk_entity_property_type", this.entityPropertyTableNames.getEntityPropertyTypeIDForeignKeyName());
        return template.createText();
    }
}

