/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IExperimentAttachmentDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dto.ExperimentFileAttachmentDTO;
import ch.systemsx.cisd.lims.server.dto.FilePropertyDTO;
import ch.systemsx.cisd.lims.server.dto.PersonDTO;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.core.support.AbstractLobCreatingPreparedStatementCallback;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.jdbc.support.lob.LobHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExperimentAttachmentDAO
extends AbstractDAO
implements IExperimentAttachmentDAO {
    private static final String EXAT_TABLE = "experiment_attachments";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ExperimentAttachmentDAO.class);
    private static final ParameterizedRowMapper<FilePropertyDTO> FILE_ATTACHMENT_MAPPER = new ParameterizedRowMapper<FilePropertyDTO>(){

        public FilePropertyDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            FilePropertyDTO fileProperty = new FilePropertyDTO();
            PersonDTO personDTO = new PersonDTO();
            personDTO.setId(rs.getLong("pid"));
            personDTO.setUserId(CodeConverter.tryToBusinessLayer(rs.getString("user_id")));
            personDTO.setEmail(rs.getString("email"));
            personDTO.setFirstName(rs.getString("first_name"));
            personDTO.setLastName(rs.getString("last_name"));
            fileProperty.setRegistrator(personDTO);
            fileProperty.setId(rs.getLong("id"));
            fileProperty.setFileName(rs.getString("file_name"));
            fileProperty.setRegistrationDate(new Date(rs.getTimestamp("registration_timestamp").getTime()));
            fileProperty.setVersion(rs.getInt("version"));
            return fileProperty;
        }
    };
    private final ExperimentAttachmentDTORowMapper rowMapper;
    private final LobHandler lobHandler;
    private final ISequenceNameMapper sequenceNameMapper;

    public ExperimentAttachmentDAO(DataSource dataSource, LobHandler lobHandler, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler, ISequenceNameMapper sequenceNameMapper) {
        super(dataSource, dtoValidatorStore, sequencerHandler);
        this.lobHandler = lobHandler;
        this.sequenceNameMapper = sequenceNameMapper;
        this.rowMapper = new ExperimentAttachmentDTORowMapper(lobHandler);
    }

    @Override
    public List<FilePropertyDTO> listExperimentAttachments(long experimentID) throws DataAccessException {
        return this.getSimpleJdbcTemplate().query("select ep.id, file_name, registration_timestamp, version, p.user_id, p.id as pid, p.email, p.first_name, p.last_name from experiment_attachments as ep, persons as p where expe_id = ? and pers_id_registerer = p.id", FILE_ATTACHMENT_MAPPER, new Object[]{experimentID});
    }

    @Override
    public void createExperimentAttachment(final long experimentID, final ExperimentFileAttachmentDTO experimentFile) throws DataAccessException {
        assert (experimentFile != null);
        assert (experimentFile.getRegistratorID() != null);
        final FilePropertyDTO fileProperty = experimentFile.getFileProperty();
        assert (fileProperty != null);
        this.validateDTO(experimentFile);
        final long id = this.getNextValueOf(this.sequenceNameMapper.getSequencerForTable(EXAT_TABLE));
        JdbcTemplate template = this.getJdbcTemplate();
        final int version = template.queryForInt("select max(version) from experiment_attachments where expe_id = ? and file_name = ?", new Object[]{experimentID, fileProperty.getFileName()}) + 1;
        template.execute("insert into experiment_attachments (id, expe_id,  pers_id_registerer, file_name, version, value) values (?,?,?,?,?,?)", (PreparedStatementCallback)new AbstractLobCreatingPreparedStatementCallback(this.lobHandler){

            protected void setValues(PreparedStatement ps, LobCreator lobCreator) throws SQLException, DataAccessException {
                ps.setLong(1, id);
                ps.setLong(2, experimentID);
                ps.setLong(3, experimentFile.getRegistratorID());
                ps.setString(4, fileProperty.getFileName());
                ps.setInt(5, version);
                lobCreator.setBlobAsBytes(ps, 6, experimentFile.getValue());
            }
        });
        fileProperty.setId(id);
        fileProperty.setVersion(version);
    }

    @Override
    public ExperimentFileAttachmentDTO tryFindExpAttachmentByExpIdAndFileName(long experimentId, String fileName) throws DataAccessException {
        assert (fileName != null);
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List result = template.query("select p.* from experiment_attachments as p, experiments as e where e.id = p.expe_id and e.id = ? and p.file_name = ? and p.version = (select max(version) from experiment_attachments as p, experiments as e where e.id = p.expe_id and e.id = ? and p.file_name = ?)", (ParameterizedRowMapper)this.rowMapper, new Object[]{experimentId, fileName, experimentId, fileName});
        int size = result.size();
        if (size == 0) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug("getExperimentAttachment('" + experimentId + "','" + fileName + "'): NULL'.");
            }
            return null;
        }
        if (size > 1) {
            throw new IncorrectResultSizeDataAccessException("More than one entity for experiment '" + experimentId + "' and file '" + fileName + "' found: " + size, 1, size);
        }
        ExperimentFileAttachmentDTO property = (ExperimentFileAttachmentDTO)result.get(0);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("getExperimentAttachment('" + experimentId + "','" + fileName + "'): #" + property.getValue().length + ".");
        }
        return property;
    }

    @Override
    public ExperimentFileAttachmentDTO tryFindExpAttachmentByExpIdAndFileNameAndVersion(long experimentId, String fileName, int version) throws DataAccessException {
        assert (fileName != null);
        assert (version > 0);
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List result = template.query("select p.* from experiment_attachments as p, experiments as e where e.id = p.expe_id and e.id = ? and p.file_name = ? and p.version = ?", (ParameterizedRowMapper)this.rowMapper, new Object[]{experimentId, fileName, version});
        int size = result.size();
        if (size == 0) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug("getExperimentAttachment('" + experimentId + "','" + fileName + "'," + version + "): NULL'.");
            }
            return null;
        }
        if (size > 1) {
            throw new IncorrectResultSizeDataAccessException("More than one entity for experiment '" + experimentId + "', file '" + fileName + "' and version " + version + " found: " + size, 1, size);
        }
        ExperimentFileAttachmentDTO property = (ExperimentFileAttachmentDTO)result.get(0);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("getExperimentAttachment('" + experimentId + "','" + fileName + "'," + version + "): #" + property.getValue().length + ".");
        }
        return property;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ExperimentAttachmentDTORowMapper
    implements ParameterizedRowMapper<ExperimentFileAttachmentDTO> {
        private final LobHandler lobHandler;

        public ExperimentAttachmentDTORowMapper(LobHandler lobHandler) {
            this.lobHandler = lobHandler;
        }

        public ExperimentFileAttachmentDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            FilePropertyDTO fileProperty = new FilePropertyDTO();
            PersonDTO person = new PersonDTO();
            long registererId = rs.getLong("pers_id_registerer");
            person.setId(registererId);
            fileProperty.setRegistrator(person);
            fileProperty.setId(rs.getLong("id"));
            fileProperty.setFileName(rs.getString("file_name"));
            fileProperty.setRegistrationDate(new Date(rs.getTimestamp("registration_timestamp").getTime()));
            fileProperty.setVersion(rs.getInt("version"));
            ExperimentFileAttachmentDTO experimentFile = new ExperimentFileAttachmentDTO(registererId);
            experimentFile.setFileProperty(fileProperty);
            experimentFile.setValue(this.lobHandler.getBlobAsBytes(rs, "value"));
            return experimentFile;
        }
    }
}

