/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.server.dataaccess.IExperimentDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractEntityDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dataaccess.db.PersonDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.properties.EntityPropertyValueRowMapper;
import ch.systemsx.cisd.lims.server.dto.BaseExperimentDTO;
import ch.systemsx.cisd.lims.server.dto.EntityPropertyValueDTO;
import ch.systemsx.cisd.lims.server.dto.EntityTypeDTO;
import ch.systemsx.cisd.lims.server.dto.ExperimentDTO;
import ch.systemsx.cisd.lims.server.dto.ExperimentTypeDTO;
import ch.systemsx.cisd.lims.server.dto.GroupDTO;
import ch.systemsx.cisd.lims.server.dto.IEntityPropertiesHolderDTO;
import ch.systemsx.cisd.lims.server.dto.MaterialDTO;
import ch.systemsx.cisd.lims.server.dto.PersonDTO;
import ch.systemsx.cisd.lims.server.dto.ProjectDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExperimentDAO
extends AbstractEntityDAO
implements IExperimentDAO {
    static final String ENTITY_PROPERTY_QUERY_TEMPLATE = "select ep.${fk_entity}, ep.${fk_entity_property_type}, ep.value, ep.pers_id_registerer, ep.cvte_id, cvt.code as cvterms_code from ${entity_property} ep left outer join controlled_vocabulary_terms cvt on ep.cvte_id = cvt.id";
    private static final BaseExperimentRowMapper EXPERIMENT_ROW_MAPPER = new BaseExperimentRowMapper();
    private static final ParameterizedRowMapper<BaseExperimentDTO> BASE_EXPERIMENT_ROW_MAPPER2 = new BaseExperimentRowMapper2();
    private static final String SELECT = "select e.id, e.code, e.registration_timestamp, e.exty_id, e.proj_id, e.inva_id, pj.code as pjcode, g.id as gid, g.code as gcode, exty.code as exty_code, exty.description as exty_description ";
    private static final String GROUP_BY_FOR_LIST_BASE_EXPERIMENTS = "e.proj_id, e.id, e.code, e.exty_id, e.mate_id_study_object, e.inva_id, e.pers_id_registerer, e.registration_timestamp";
    private static final String LIST_BASE_EXPERIMENTS_SELECT = "select e.proj_id, e.id, e.code, e.exty_id, e.mate_id_study_object, e.inva_id, e.pers_id_registerer, e.registration_timestamp, max(d.registration_timestamp) as last_dataset_timestamp";
    public static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ExperimentDAO.class);
    private static final String DATA_WITHOUT_INVALID_SAMPLES = " (select data.proc_id_produced_by, data.registration_timestamp from data join samples on ((data.samp_id_acquired_from = samples.id or data.samp_id_derived_from = samples.id) and samples.inva_id is null))";

    public ExperimentDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler) {
        super(EntityKind.EXPERIMENT, dataSource, dtoValidatorStore, sequencerHandler);
    }

    public final EntityPropertyValueRowMapper createEntityPropertyValueRowMapper() {
        return new EntityPropertyValueRowMapper(this.entityPropertyTableNames);
    }

    @Override
    public final void createExperiment(ExperimentDTO experiment) throws DataAccessException {
        assert (experiment != null) : "Given experiment can not be null.";
        long personID = experiment.getRegistratorID();
        this.validateDTO(experiment);
        long studyObjectId = experiment.getStudyObject().getId();
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        long experimentID = this.getNextValueOf("experiment_id_seq");
        String code = CodeConverter.tryToDatabase(experiment.getCode());
        long experimentTypeId = experiment.getExperimentType().getId();
        experiment.getExperimentType().setId(experimentTypeId);
        Long projectId = experiment.getProject().getId();
        template.update("insert into experiments (id, code, pers_id_registerer, mate_id_study_object, exty_id, proj_id) values (?,?,?,?,?,?)", new Object[]{experimentID, code, personID, studyObjectId, experimentTypeId, projectId});
        experiment.setId(experimentID);
    }

    @Override
    public final long getExperimentIdByCode(long groupId, long projectId, String experimentCode) {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        return template.queryForLong("select e.id from experiments as e, projects as p where p.grou_id = ? and p.id = e.proj_id and e.proj_id = ? and e.code = ?", new Object[]{groupId, projectId, CodeConverter.tryToDatabase(experimentCode)});
    }

    @Override
    public final ExperimentDTO getExperimentWithRegistratorMaterialProject(long id) {
        assert (id > 0L);
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List result = template.query("select e.id, e.code, e.registration_timestamp, e.exty_id, e.proj_id, e.inva_id, pj.code as pjcode, g.id as gid, g.code as gcode, exty.code as exty_code, exty.description as exty_description ,  p.id as pid, p.user_id, p.first_name, p.last_name, p.email , m.id as study_object_id, m.code as study_object_code, maty.id as soty_id, maty.code as soty_code, maty.description as soty_description, g.code as gcode from experiments as e, experiment_types as exty, material_types as maty, materials as m, projects as pj, groups as g, persons as p where e.id = ? and e.pers_id_registerer = p.id and pj.id = e.proj_id and pj.grou_id = g.id and e.mate_id_study_object = m.id and e.exty_id = exty.id and maty.id = m.maty_id", (ParameterizedRowMapper)new ExperimentRowMapper(), new Object[]{id});
        if (result.size() == 0) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug("getExperiment(" + id + "): NULL'.");
            }
            throw new EmptyResultDataAccessException("No experiment found with id " + id, 1);
        }
        int size = result.size();
        if (size > 1) {
            throw new IncorrectResultSizeDataAccessException("More than one experiment for id " + id + " found: " + size, 1, size);
        }
        assert (size == 1);
        ExperimentDTO experiment = (ExperimentDTO)result.get(0);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("getExperiment(" + id + "): '" + experiment.getCode() + "'.");
        }
        return experiment;
    }

    @Override
    public final List<BaseExperimentDTO> listBaseExperiments(long groupId, boolean suppressInvalid) {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        StringBuilder sql = new StringBuilder();
        sql.append(LIST_BASE_EXPERIMENTS_SELECT);
        sql.append(" from projects pr, experiments e");
        sql.append(" left outer join procedures p on e.id = p.expe_id");
        sql.append(" left outer join  (select data.proc_id_produced_by, data.registration_timestamp from data join samples on ((data.samp_id_acquired_from = samples.id or data.samp_id_derived_from = samples.id) and samples.inva_id is null)) as d on p.id = d.proc_id_produced_by");
        sql.append(" where pr.id = e.proj_id");
        if (suppressInvalid) {
            sql.append(" and e.inva_id is null");
        }
        sql.append(" and pr.grou_id = ?");
        sql.append(" group by ").append(GROUP_BY_FOR_LIST_BASE_EXPERIMENTS);
        return template.query(sql.toString(), BASE_EXPERIMENT_ROW_MAPPER2, new Object[]{groupId});
    }

    @Override
    public final List<BaseExperimentDTO> listBaseExperiments(boolean invalidExperimentSuppressed) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        StringBuilder sql = new StringBuilder();
        sql.append(LIST_BASE_EXPERIMENTS_SELECT);
        sql.append(" from projects pr, experiments e");
        sql.append(" left outer join procedures p on e.id = p.expe_id");
        sql.append(" left outer join  (select data.proc_id_produced_by, data.registration_timestamp from data join samples on ((data.samp_id_acquired_from = samples.id or data.samp_id_derived_from = samples.id) and samples.inva_id is null)) as d on p.id = d.proc_id_produced_by");
        sql.append(" where pr.id = e.proj_id");
        if (invalidExperimentSuppressed) {
            sql.append(" and e.inva_id is null");
        }
        sql.append(" group by ").append(GROUP_BY_FOR_LIST_BASE_EXPERIMENTS);
        return template.query(sql.toString(), BASE_EXPERIMENT_ROW_MAPPER2, new Object[0]);
    }

    @Override
    public final List<BaseExperimentDTO> listBaseExperiments(long groupId, long experimentTypeId, boolean invalidExperimentSuppressed) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        StringBuilder sql = new StringBuilder();
        sql.append(LIST_BASE_EXPERIMENTS_SELECT);
        sql.append(" from projects pr, experiments e join experiment_types t on t.id = e.exty_id");
        sql.append(" left outer join procedures p on e.id = p.expe_id");
        sql.append(" left outer join  (select data.proc_id_produced_by, data.registration_timestamp from data join samples on ((data.samp_id_acquired_from = samples.id or data.samp_id_derived_from = samples.id) and samples.inva_id is null)) as d on p.id = d.proc_id_produced_by");
        sql.append(" where pr.id = e.proj_id");
        if (invalidExperimentSuppressed) {
            sql.append(" and e.inva_id is null");
        }
        sql.append(" and pr.grou_id = ? and t.id = ?");
        sql.append(" group by ").append(GROUP_BY_FOR_LIST_BASE_EXPERIMENTS);
        return template.query(sql.toString(), BASE_EXPERIMENT_ROW_MAPPER2, new Object[]{groupId, experimentTypeId});
    }

    @Override
    public final ExperimentDTO getExperimentByProcedureId(long procedureId) throws DataAccessException {
        StringBuilder builder = new StringBuilder();
        builder.append(SELECT).append(",  p.id as pid, p.user_id, p.first_name, p.last_name, p.email ");
        builder.append(" from ").append("experiments").append(" as e, ").append("experiment_types");
        builder.append(" as exty, ").append("procedures").append(" as pr, ");
        builder.append("projects").append(" as pj, ").append("groups");
        builder.append(" as g, ").append("persons").append(" as p ");
        builder.append("where pj.id = e.proj_id and pj.grou_id = g.id and e.pers_id_registerer = p.id");
        builder.append(" and pr.expe_id = e.id and pr.id = ?");
        return (ExperimentDTO)this.getSimpleJdbcTemplate().queryForObject(builder.toString(), (ParameterizedRowMapper)EXPERIMENT_ROW_MAPPER, new Object[]{procedureId});
    }

    @Override
    public final boolean invalidateExperiment(long experimentID, long invalidationID) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        int affectedRows = template.update("update experiments set inva_id = ? where id = ? and inva_id is null", new Object[]{invalidationID, experimentID});
        if (affectedRows > 1) {
            throw new IncorrectResultSizeDataAccessException("Expected at most one experiment, but found " + affectedRows, 1, affectedRows);
        }
        return affectedRows == 1;
    }

    @Override
    public final List<IEntityPropertiesHolderDTO> listAllEntityProperties() throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        String sql = this.createPropertiesSql(ENTITY_PROPERTY_QUERY_TEMPLATE);
        EntityPropertyValueRowMapper mapper = this.createEntityPropertyValueRowMapper();
        template.query(sql, (ParameterizedRowMapper)mapper, new Object[0]);
        List<IEntityPropertiesHolderDTO> list = mapper.getEntityPropertiesHolders();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d experiment property holder(s) has(have) been found.", list.size()));
        }
        return list;
    }

    @Override
    public final List<EntityPropertyValueDTO> listEntityProperties(long entityId) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        String sql = this.createPropertiesSql("select ep.${fk_entity}, ep.${fk_entity_property_type}, ep.value, ep.pers_id_registerer, ep.cvte_id, cvt.code as cvterms_code from ${entity_property} ep left outer join controlled_vocabulary_terms cvt on ep.cvte_id = cvt.id where ${fk_entity} = ?");
        EntityPropertyValueRowMapper mapper = this.createEntityPropertyValueRowMapper();
        List list = template.query(sql, (ParameterizedRowMapper)mapper, new Object[]{entityId});
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d experiment property(ies) has(have) been found for experiment id %d.", list.size(), entityId));
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BaseExperimentRowMapper
    implements ParameterizedRowMapper<ExperimentDTO> {
        private BaseExperimentRowMapper() {
        }

        private static final ProjectDTO fillProjectFromResultSet(ResultSet rs) throws SQLException {
            ProjectDTO project = new ProjectDTO(rs.getLong("gid"));
            project.setId(rs.getLong("proj_id"));
            project.setCode(CodeConverter.tryToBusinessLayer(rs.getString("pjcode")));
            GroupDTO group = new GroupDTO();
            group.setCode(CodeConverter.tryToBusinessLayer(rs.getString("gcode")));
            group.setId(project.getGroupId());
            project.setGroup(group);
            return project;
        }

        public ExperimentDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            PersonDTO person = PersonDAO.fillPersonFromResultSet(rs);
            ExperimentDTO experiment = new ExperimentDTO(person.getId());
            experiment.setRegistrator(person);
            experiment.setId(rs.getLong("id"));
            experiment.setCode(CodeConverter.tryToBusinessLayer(rs.getString("code")));
            experiment.setRegistrationDate(new Date(rs.getTimestamp("registration_timestamp").getTime()));
            long id = rs.getLong("inva_id");
            if (!rs.wasNull()) {
                experiment.setInvalidationId(id);
            }
            ExperimentTypeDTO experimentType = new ExperimentTypeDTO();
            experimentType.setId(rs.getLong("exty_id"));
            experimentType.setCode(rs.getString("exty_code"));
            experimentType.setDescription(rs.getString("exty_description"));
            experiment.setExperimentType(experimentType);
            experiment.setProject(BaseExperimentRowMapper.fillProjectFromResultSet(rs));
            return experiment;
        }

        /* synthetic */ BaseExperimentRowMapper(BaseExperimentRowMapper baseExperimentRowMapper, BaseExperimentRowMapper baseExperimentRowMapper2) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BaseExperimentRowMapper2
    implements ParameterizedRowMapper<BaseExperimentDTO> {
        private BaseExperimentRowMapper2() {
        }

        public final BaseExperimentDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            BaseExperimentDTO experiment = new BaseExperimentDTO(rs.getLong("pers_id_registerer"));
            experiment.setId(rs.getLong("id"));
            experiment.setProjectID(rs.getLong("proj_id"));
            experiment.setCode(rs.getString("code"));
            experiment.setExperimentTypeID(rs.getLong("exty_id"));
            experiment.setStudyObjectID(rs.getLong("mate_id_study_object"));
            experiment.setRegistrationDate(new Date(rs.getTimestamp("registration_timestamp").getTime()));
            long id = rs.getLong("inva_id");
            if (!rs.wasNull()) {
                experiment.setInvalidationId(id);
            }
            Timestamp timestamp = rs.getTimestamp("last_dataset_timestamp");
            if (!rs.wasNull()) {
                experiment.setLastDataSetDate(new Date(timestamp.getTime()));
            }
            return experiment;
        }
    }

    private final class ExperimentRowMapper
    extends BaseExperimentRowMapper {
        private ExperimentRowMapper() {
            super(null, null);
        }

        public final ExperimentDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            ExperimentDTO experiment = super.mapRow(rs, rowNum);
            EntityTypeDTO studyObjectType = new EntityTypeDTO();
            studyObjectType.setId(rs.getLong("soty_id"));
            studyObjectType.setCode(CodeConverter.tryToBusinessLayer(rs.getString("soty_code")));
            studyObjectType.setDescription(rs.getString("soty_description"));
            MaterialDTO studyObject = new MaterialDTO(null);
            studyObject.setMaterialType(studyObjectType);
            studyObject.setId(rs.getLong("study_object_id"));
            studyObject.setCode(CodeConverter.tryToBusinessLayer(rs.getString("study_object_code")));
            experiment.setStudyObject(studyObject);
            ProjectDTO project = experiment.getProject();
            GroupDTO group = new GroupDTO();
            group.setCode(CodeConverter.tryToBusinessLayer(rs.getString("gcode")));
            group.setId(project.getGroupId());
            project.setGroup(group);
            return experiment;
        }
    }
}

