/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.collections.IKeyExtractor;
import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.types.BooleanOrUnknown;
import ch.systemsx.cisd.lims.base.util.StorageFormat;
import ch.systemsx.cisd.lims.server.dataaccess.IExternalDataDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dataaccess.db.TableNames;
import ch.systemsx.cisd.lims.server.dto.DataDTO;
import ch.systemsx.cisd.lims.server.dto.ExternalDataDTO;
import ch.systemsx.cisd.lims.server.dto.FileFormatTypeDTO;
import ch.systemsx.cisd.lims.server.dto.Id;
import ch.systemsx.cisd.lims.server.dto.LocatorTypeDTO;
import ch.systemsx.cisd.lims.server.dto.ObservableTypeDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExternalDataDAO
extends AbstractDAO
implements IExternalDataDAO {
    private static final String STORAGE_FORMAT_CONTROLLED_VOCABULARY_CODE = "STORAGE_FORMAT";
    private static final String DATA_WITH_PARENT_LEFT_OUTER_JOIN = String.format("%s d left outer join %s r on d.id = r.data_id_child left outer join %s parent on r.data_id_parent = parent.id ", "data", "data_set_relationships", "data");
    private static final String SELECT_FROM = String.format("select e.*, c.code as cvte_code, d.code as code, d.registration_timestamp, d.data_producer_code, d.id, d.production_timestamp, d.proc_id_produced_by as pid, d.is_placeholder, f.id as ffty_id, f.code as ffty_code, f.description as ffty_description, o.id as obty_id, o.code as obty_code, o.description as obty_description, l.id as loty_id, l.code as loty_code, l.description as loty_description, parent.code as parent_code from %s e, %s f, %s o, %s l, %s c, " + DATA_WITH_PARENT_LEFT_OUTER_JOIN, "external_data", TableNames.FILE_FORMAT_TYPES_TABLE, "observable_types", TableNames.LOCATOR_TYPES_TABLE, TableNames.CONTROLLED_VOCABULARY_TERMS_TABLE);
    private static final String BASIC_WHERE = "where f.id = e.ffty_id and o.id = d.obty_id and l.id = e.loty_id and d.id = e.data_id and c.id = e.cvte_id_stor_fmt ";
    private static final String DATA_CODE_DATE_FORMAT_PATTERN = "yyyyMMddHHmmssSSS";
    private final long unknownObservableTypeId;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ExternalDataDAO.class);
    private final ISequenceNameMapper sequenceNameMapper;

    ExternalDataDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler, ISequenceNameMapper sequenceNameMapper, long unknownObservableTypeId) {
        super(dataSource, dtoValidatorStore, sequencerHandler);
        this.sequenceNameMapper = sequenceNameMapper;
        this.unknownObservableTypeId = unknownObservableTypeId;
    }

    private final long createID() {
        return this.getNextValueOf(this.sequenceNameMapper.getSequencerForTable("data"));
    }

    private final long createRelationshipID() {
        return this.getNextValueOf(this.sequenceNameMapper.getSequencerForTable("data_set_relationships"));
    }

    private static final String generateAndSetDataCodeIfNecessary(ExternalDataDTO data, long id) {
        String dataCode;
        if (data.getCode() == null) {
            dataCode = ExternalDataDAO.generateDataCode(new Date(), id);
            data.setCode(dataCode);
        } else {
            dataCode = CodeConverter.tryToDatabase(data.getCode());
        }
        return dataCode;
    }

    static final String generateDataCode(Date date, long id) {
        assert (date != null) : "Unspecified date.";
        return String.valueOf(DateFormatUtils.format(date, DATA_CODE_DATE_FORMAT_PATTERN)) + "-" + Long.toString(id);
    }

    private final void insertExternalData(ExternalDataDTO externalData, long id, SimpleJdbcTemplate template) {
        assert (externalData != null) : "Given data can not be null.";
        assert (externalData.getFileFormatType() != null) : "File format type of given data can not be null.";
        assert (externalData.getStorageFormat() != null) : "Storage format of given data can not be null.";
        template.update("insert into external_data (data_id, ffty_id, location, loty_id, is_complete, cvte_id_stor_fmt) values (?,?,?,?,?, (select cvte.id from controlled_vocabularies as cv, controlled_vocabulary_terms as cvte where cv.is_internal_namespace = true and cv.code = ? and cv.id = cvte.covo_id and cvte.code = ?))", new Object[]{id, externalData.getFileFormatType().getId(), externalData.getLocation(), externalData.getLocatorType().getId(), externalData.getComplete().getDatabaseRepresentation(), STORAGE_FORMAT_CONTROLLED_VOCABULARY_CODE, externalData.getStorageFormat().getCode()});
        externalData.setId(id);
    }

    @Override
    public final void createExternalData(ExternalDataDTO externalData, long sampleId, IExternalDataDAO.SourceType sourceType) throws DataAccessException {
        assert (externalData != null) : "Given data can not be null.";
        assert (externalData.getObservableType() != null) : "Observable type of given data can not be null.";
        assert (externalData.getProcedureID() != null) : "Procedure id of given data can not be null.";
        this.validateDTO(externalData);
        long id = this.createID();
        String dataCode = ExternalDataDAO.generateAndSetDataCodeIfNecessary(externalData, id);
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("insert into data (id, code, obty_id, proc_id_produced_by, data_producer_code, production_timestamp, " + sourceType.getFieldName() + ") values (?,?,?,?,?,?,?)", new Object[]{id, dataCode, externalData.getObservableType().getId(), externalData.getProcedureID(), externalData.getDataProducerCode(), externalData.getProductionDate(), sampleId});
        this.insertExternalData(externalData, id, template);
    }

    @Override
    public final void updateExternalData(ExternalDataDTO externalData, long sampleId, IExternalDataDAO.SourceType sourceType) throws DataAccessException {
        assert (externalData != null) : "Given data can not be null.";
        assert (externalData.getCode() != null) : "Data Set code can not be null.";
        assert (externalData.getObservableType() != null) : "Observable type of given data can not be null.";
        assert (externalData.getProcedureID() != null) : "Procedure id of given data can not be null.";
        this.validateDTO(externalData);
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        String fieldName = sourceType.getFieldName();
        String producerFieldName = sourceType.getProducerFieldName();
        String sql = String.format("update data set is_placeholder = false, registration_timestamp = ?, obty_id = ?, proc_id_produced_by = ?, data_producer_code = ?, production_timestamp = ?, %s = ?, %s = NULL where code = ? returning id", fieldName, producerFieldName);
        long id = template.queryForLong(sql, new Object[]{new Date(), externalData.getObservableType().getId(), externalData.getProcedureID(), externalData.getDataProducerCode(), externalData.getProductionDate(), sampleId, CodeConverter.tryToDatabase(externalData.getCode())});
        this.insertExternalData(externalData, id, template);
    }

    @Override
    public final long createPlaceholderData(String code, long procedureId, long sampleId) {
        assert (code != null) : "Unspecified data set code.";
        long id = this.createID();
        String mangledCode = CodeConverter.tryToDatabase(code);
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("insert into data (id, code, obty_id, proc_id_produced_by, samp_id_derived_from, is_placeholder) values (?,?,?,?,?,true)", new Object[]{id, mangledCode, this.unknownObservableTypeId, procedureId, sampleId});
        return id;
    }

    @Override
    public final List<ExternalDataDTO> listExternalData(long sampleId, IExternalDataDAO.SourceType sourceType) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        String sql = String.valueOf(SELECT_FROM) + BASIC_WHERE + "and d." + sourceType.getFieldName() + " = ?";
        ExternalDataRowMapper rowMapper = new ExternalDataRowMapper();
        template.query(sql, (ParameterizedRowMapper)rowMapper, new Object[]{sampleId});
        List<ExternalDataDTO> list = rowMapper.getExternalDataDTOs();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.valueOf(list.size()) + " external data set(s) have been found for sample id '" + sampleId + "'.");
        }
        return list;
    }

    @Override
    public final List<ExternalDataDTO> findExternalData(Collection<Long> ids) {
        String idString = StringUtils.join(ids, ',');
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        ExternalDataRowMapper rowMapper = new ExternalDataRowMapper();
        template.query(String.valueOf(SELECT_FROM) + BASIC_WHERE + "and d.id in (" + idString + ")", (ParameterizedRowMapper)rowMapper, new Object[0]);
        List<ExternalDataDTO> list = rowMapper.getExternalDataDTOs();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.valueOf(list.size()) + " external data set(s) have been found for " + ids.size() + " ids.");
        }
        return list;
    }

    @Override
    public final DataDTO tryGetData(String code) {
        String mangledCode = CodeConverter.tryToDatabase(code);
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        DataRowMapper rowMapper = new DataRowMapper();
        template.query(String.format("select d.*, d.proc_id_produced_by as pid, obty.code as obty_code, obty.description as obty_description, parent.code as parent_code from %s obty, " + DATA_WITH_PARENT_LEFT_OUTER_JOIN + "where d.obty_id = obty.id and d.code = ?", "observable_types"), rowMapper, new Object[]{mangledCode});
        List list = rowMapper.getDataDTOs();
        if (list.size() > 1) {
            throw new DataRetrievalFailureException("Expected zero or one entries, got " + list.size());
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.valueOf(list.size()) + " data set(s) have been found for code '" + mangledCode + "'.");
        }
        if (list.isEmpty()) {
            return null;
        }
        return (DataDTO)list.get(0);
    }

    @Override
    public final void createDataSetRelationship(long parentDataSetId, long childDataSetId) {
        long id = this.createRelationshipID();
        this.getSimpleJdbcTemplate().update(String.format("insert into %s (id, data_id_parent, data_id_child) values (?,?,?)", "data_set_relationships"), new Object[]{id, parentDataSetId, childDataSetId});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DataRowMapper<T extends DataDTO>
    implements ParameterizedRowMapper<T> {
        private final TableMap<Long, T> map = new TableMap(new IKeyExtractor<Long, T>(){

            @Override
            public final Long getKey(T e) {
                return ((Id)e).getId();
            }
        }, TableMap.UniqueKeyViolationStrategy.KEEP_FIRST);

        DataRowMapper() {
        }

        private static final ObservableTypeDTO createObservableTypeDTO(ResultSet rs) throws SQLException {
            ObservableTypeDTO observableType = new ObservableTypeDTO();
            observableType.setId(rs.getLong("obty_id"));
            observableType.setCode(rs.getString("obty_code"));
            observableType.setDescription(rs.getString("obty_description"));
            return observableType;
        }

        private final T cast(DataDTO data) {
            return (T)data;
        }

        final List<T> getDataDTOs() {
            return new ArrayList<T>(this.map.values());
        }

        DataDTO createDataDTO(Long procedureId) {
            return new DataDTO(procedureId);
        }

        public T mapRow(ResultSet rs, int rowNum) throws SQLException {
            T data = this.cast(this.createDataDTO(rs.getLong("pid")));
            ((Id)data).setId(rs.getLong("id"));
            ((DataDTO)data).setPlaceholder(rs.getBoolean("is_placeholder"));
            ((DataDTO)data).setCode(CodeConverter.tryToBusinessLayer(rs.getString("code")));
            ((DataDTO)data).setRegistrationDate(new Date(rs.getTimestamp("registration_timestamp").getTime()));
            ((DataDTO)data).setDataProducerCode(rs.getString("data_producer_code"));
            Timestamp measurementTimestamp = rs.getTimestamp("production_timestamp");
            if (measurementTimestamp != null) {
                ((DataDTO)data).setProductionDate(new Date(measurementTimestamp.getTime()));
            }
            ((DataDTO)data).setObservableType(DataRowMapper.createObservableTypeDTO(rs));
            ((DataDTO)data).setParentDataSetCode(rs.getString("parent_code"));
            this.map.add(data);
            return data;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ExternalDataRowMapper
    extends DataRowMapper<ExternalDataDTO> {
        private ExternalDataRowMapper() {
        }

        private final FileFormatTypeDTO createFileFormatTypeDTO(ResultSet rs) throws SQLException {
            FileFormatTypeDTO fileFormatType = new FileFormatTypeDTO();
            fileFormatType.setId(rs.getLong("ffty_id"));
            fileFormatType.setCode(rs.getString("ffty_code"));
            fileFormatType.setDescription(rs.getString("ffty_description"));
            return fileFormatType;
        }

        private final LocatorTypeDTO createLocatorTypeDTO(ResultSet rs) throws SQLException {
            LocatorTypeDTO locatorType = new LocatorTypeDTO();
            locatorType.setId(rs.getLong("loty_id"));
            locatorType.setCode(rs.getString("loty_code"));
            locatorType.setDescription(rs.getString("loty_description"));
            return locatorType;
        }

        final List<ExternalDataDTO> getExternalDataDTOs() {
            return this.getDataDTOs();
        }

        @Override
        protected final DataDTO createDataDTO(Long procedureId) {
            return new ExternalDataDTO(procedureId);
        }

        @Override
        public final ExternalDataDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            ExternalDataDTO externalData = (ExternalDataDTO)super.mapRow(rs, rowNum);
            externalData.setLocation(rs.getString("location"));
            externalData.setComplete(BooleanOrUnknown.fromDatabaseRepresentation(rs.getString("is_complete")));
            String storageFormatCode = rs.getString("cvte_code");
            externalData.setStorageFormat(StorageFormat.tryGetFromCode(storageFormatCode));
            if (externalData.getStorageFormat() == null) {
                throw new DataIntegrityViolationException("Illegal storage format code '" + storageFormatCode + "'.");
            }
            externalData.setFileFormatType(this.createFileFormatTypeDTO(rs));
            externalData.setLocatorType(this.createLocatorTypeDTO(rs));
            return externalData;
        }
    }
}

