/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IInvalidationDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dataaccess.db.PersonDAO;
import ch.systemsx.cisd.lims.server.dto.InvalidationDTO;
import ch.systemsx.cisd.lims.server.dto.PersonDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InvalidationDAO
extends AbstractDAO
implements IInvalidationDAO {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, InvalidationDAO.class);
    private static final String ID_SEQUENCE = "INVALIDATION_ID_SEQ";
    private static final String WITH_USER = ", invp.id as invp_pid, invp.user_id as invp_user_id, invp.first_name as invp_first_name, invp.last_name as invp_last_name, invp.email as invp_email ";
    private static final String JOIN_WITH_INVALIDATIONS_ON = "left outer join invalidations as inv on inv.id = ";
    private static final String JOIN_WITH_REGISTRATOR = "left outer join persons as invp on inv.pers_id_registerer = invp.id ";
    private static final String ONLY_INVALIDATION_FIELDS = "inv.id as inv_id, inv.pers_id_registerer as inv_registerer, inv.reason as inv_reason, inv.registration_timestamp as inv_date ";
    private static final ParameterizedRowMapper<InvalidationDTO> INVALIDATION_ROW_MAPPER = new ParameterizedRowMapper<InvalidationDTO>(){

        public final InvalidationDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            InvalidationDTO invalidation = InvalidationDAO.tryFillInvalidationFromResultSet(rs, true);
            return invalidation;
        }
    };
    static final String FIELDS = "inv.id as inv_id, inv.pers_id_registerer as inv_registerer, inv.reason as inv_reason, inv.registration_timestamp as inv_date , invp.id as invp_pid, invp.user_id as invp_user_id, invp.first_name as invp_first_name, invp.last_name as invp_last_name, invp.email as invp_email ";

    InvalidationDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler) {
        super(dataSource, dtoValidatorStore, sequencerHandler);
    }

    private final long createID() {
        return this.getNextValueOf(ID_SEQUENCE);
    }

    @Override
    public final void createInvalidation(InvalidationDTO invalidation) {
        assert (invalidation != null) : "Given invalidation can not be null.";
        this.validateDTO(invalidation);
        long id = this.createID();
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("insert into invalidations (id, reason, pers_id_registerer) values (?,?,?)", new Object[]{id, invalidation.getReason(), invalidation.getRegistratorID()});
        invalidation.setId(id);
    }

    @Override
    public final List<InvalidationDTO> listInvalidations() throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query("select inv.id as inv_id, inv.pers_id_registerer as inv_registerer, inv.reason as inv_reason, inv.registration_timestamp as inv_date , invp.id as invp_pid, invp.user_id as invp_user_id, invp.first_name as invp_first_name, invp.last_name as invp_last_name, invp.email as invp_email from invalidations inv left outer join persons as invp on inv.pers_id_registerer = invp.id ", INVALIDATION_ROW_MAPPER, new Object[0]);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("listInvalidations(): " + list.size() + " invalidation(s) have been found.");
        }
        return list;
    }

    static InvalidationDTO tryFillInvalidationFromResultSet(ResultSet rs, boolean withRegistrator) throws SQLException {
        long invalidationId = rs.getLong("inv_id");
        if (rs.wasNull()) {
            return null;
        }
        long registratorId = rs.getLong("inv_registerer");
        String invalidationReason = rs.getString("inv_reason");
        Date registrationDate = new Date(rs.getTimestamp("inv_date").getTime());
        InvalidationDTO invalidation = new InvalidationDTO(registratorId);
        if (withRegistrator) {
            PersonDTO person = PersonDAO.fillPersonFromResultSet(rs, "invp_pid", "invp_user_id", "invp_first_name", "invp_last_name", "invp_email");
            invalidation.setRegistrator(person);
        }
        invalidation.setId(invalidationId);
        invalidation.setReason(invalidationReason);
        invalidation.setRegistrationDate(registrationDate);
        return invalidation;
    }

    static final String getJoinWithInvalidationsOn(String foreignKey) {
        return JOIN_WITH_INVALIDATIONS_ON + foreignKey + " " + JOIN_WITH_REGISTRATOR;
    }
}

