/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IPropertyTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dto.DataTypeDTO;
import ch.systemsx.cisd.lims.server.dto.PropertyTypeDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PropertyTypeDAO
extends AbstractDAO
implements IPropertyTypeDAO {
    private static final String SELECT = "select p.code as pcode, p.id as pid, p.description as pdescription, p.label as plabel, p.pers_id_registerer, p.registration_timestamp as preg_timestamp, p.is_internal_namespace as p_is_internal_namespace, p.is_managed_internally as pis_managed_internally, d.id as did, d.code as dcode, covo.code as covo_code, covo.id as covo_id, covo.is_internal_namespace as covo_is_internal_namespace ";
    private static final String SELECT_PROPERTY_TYPES = "select p.code as pcode, p.id as pid, p.description as pdescription, p.label as plabel, p.pers_id_registerer, p.registration_timestamp as preg_timestamp, p.is_internal_namespace as p_is_internal_namespace, p.is_managed_internally as pis_managed_internally, d.id as did, d.code as dcode, covo.code as covo_code, covo.id as covo_id, covo.is_internal_namespace as covo_is_internal_namespace from property_types as p left outer join controlled_vocabularies as covo on p.covo_id = covo.id, data_types as d where p.daty_id = d.id ";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, PropertyTypeDAO.class);
    private static final Logger operationExTrackingLog = LogFactory.getLogger(LogCategory.OPERATION, PropertyTypeDAO.class);
    private static final ParameterizedRowMapper<PropertyTypeDTO> PROPERTY_TYPE_ROW_MAPPER = new ParameterizedRowMapper<PropertyTypeDTO>(){

        public final PropertyTypeDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            Long registratorID = rs.getLong("pers_id_registerer");
            Long vocabularyID = PropertyTypeDAO.tryGetLong(rs, "covo_id");
            PropertyTypeDTO propertyType = new PropertyTypeDTO(registratorID, rs.getLong("did"), vocabularyID);
            boolean propertyInternalNamespace = rs.getBoolean("p_is_internal_namespace");
            boolean vocabularyInternalNamespace = rs.getBoolean("covo_is_internal_namespace");
            propertyType.setId(rs.getLong("pid"));
            propertyType.setCode(CodeConverter.tryToBusinessLayer(rs.getString("pcode"), !propertyInternalNamespace));
            propertyType.setUserLabel(rs.getString("plabel"));
            propertyType.setDescription(rs.getString("pdescription"));
            propertyType.setVocabularyCode(CodeConverter.tryToBusinessLayer(rs.getString("covo_code"), !vocabularyInternalNamespace));
            propertyType.setManagedInternally(rs.getBoolean("pis_managed_internally"));
            propertyType.setInternalNamespace(propertyInternalNamespace);
            DataTypeDTO dataType = new DataTypeDTO();
            dataType.setId(rs.getLong("did"));
            dataType.setCode(rs.getString("dcode"));
            propertyType.setType(dataType);
            propertyType.setRegistrationDate(new Date(rs.getTimestamp("preg_timestamp").getTime()));
            return propertyType;
        }
    };
    private static final ParameterizedRowMapper<DataTypeDTO> DATA_TYPE_ROW_MAPPER = new ParameterizedRowMapper<DataTypeDTO>(){

        public final DataTypeDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            DataTypeDTO dataType = new DataTypeDTO();
            dataType.setId(rs.getLong("id"));
            dataType.setCode(rs.getString("code"));
            dataType.setDescription(rs.getString("description"));
            return dataType;
        }
    };
    private final ISequenceNameMapper sequenceNameMapper;

    private static Long tryGetLong(ResultSet rs, String columnName) throws SQLException {
        long result = rs.getLong(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    PropertyTypeDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler, ISequenceNameMapper sequenceNameMapper) {
        super(dataSource, dtoValidatorStore, sequencerHandler);
        this.sequenceNameMapper = sequenceNameMapper;
    }

    @Override
    public final List<DataTypeDTO> listDataTypes() throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query("select * from data_types", DATA_TYPE_ROW_MAPPER, new Object[0]);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("listDataTypes(): " + list.size() + " data type(s) have been found.");
        }
        return list;
    }

    @Override
    public final void createPropertyType(PropertyTypeDTO propertyType) throws DataAccessException {
        assert (propertyType != null) : "Missing property type.";
        this.validateDTO(propertyType);
        String mangledPropertyTypeCode = CodeConverter.tryToDatabase(propertyType.getCode());
        long id = this.getNextValueOf(this.sequenceNameMapper.getSequencerForTable("property_types"));
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("insert into property_types (id, code, description, label, daty_id, pers_id_registerer, covo_id) values (?,?,?,?,?,?,?)", new Object[]{id, mangledPropertyTypeCode, propertyType.getDescription(), propertyType.getUserLabel(), propertyType.getTypeId(), propertyType.getRegistratorID(), propertyType.getVocabularyId()});
        if (operationExTrackingLog.isInfoEnabled()) {
            operationExTrackingLog.info("ADD: property type '" + mangledPropertyTypeCode + "'.");
        }
        propertyType.setId(id);
    }

    @Override
    public final List<PropertyTypeDTO> listPropertyTypes() throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query("select p.code as pcode, p.id as pid, p.description as pdescription, p.label as plabel, p.pers_id_registerer, p.registration_timestamp as preg_timestamp, p.is_internal_namespace as p_is_internal_namespace, p.is_managed_internally as pis_managed_internally, d.id as did, d.code as dcode, covo.code as covo_code, covo.id as covo_id, covo.is_internal_namespace as covo_is_internal_namespace from property_types as p left outer join controlled_vocabularies as covo on p.covo_id = covo.id, data_types as d where p.daty_id = d.id  and p.is_managed_internally = false", PROPERTY_TYPE_ROW_MAPPER, new Object[0]);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("listPropertyTypes(): " + list.size() + " property type(s) have been found.");
        }
        return list;
    }

    @Override
    public final Long tryFindPropertyTypeIdByCode(String propertyTypeCode) {
        boolean internalNamespace = CodeConverter.isInternalNamespace(propertyTypeCode);
        String propertyTypeCodeManged = CodeConverter.tryToDatabase(propertyTypeCode);
        return this.tryFindId("select id from property_types where is_internal_namespace = ? and code = ?", internalNamespace, propertyTypeCodeManged);
    }

    @Override
    public PropertyTypeDTO tryGetPropertyTypeByCode(String code) throws DataAccessException {
        String mangledPropertyTypeCode = CodeConverter.tryToDatabase(code);
        boolean internalNamespace = CodeConverter.isInternalNamespace(code);
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query("select p.code as pcode, p.id as pid, p.description as pdescription, p.label as plabel, p.pers_id_registerer, p.registration_timestamp as preg_timestamp, p.is_internal_namespace as p_is_internal_namespace, p.is_managed_internally as pis_managed_internally, d.id as did, d.code as dcode, covo.code as covo_code, covo.id as covo_id, covo.is_internal_namespace as covo_is_internal_namespace from property_types as p left outer join controlled_vocabularies as covo on p.covo_id = covo.id, data_types as d where p.daty_id = d.id  and p.is_internal_namespace = ? and p.code = ?", PROPERTY_TYPE_ROW_MAPPER, new Object[]{internalNamespace, mangledPropertyTypeCode});
        if (list.size() == 0) {
            return null;
        }
        assert (list.size() == 1);
        return (PropertyTypeDTO)list.get(0);
    }
}

