/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.server.dataaccess.ISampleComponentDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dto.EntityTypeDTO;
import ch.systemsx.cisd.lims.server.dto.MaterialBatchDTO;
import ch.systemsx.cisd.lims.server.dto.MaterialDTO;
import ch.systemsx.cisd.lims.server.dto.SampleComponentDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SampleComponentDAO
extends AbstractDAO
implements ISampleComponentDAO {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, SampleComponentDAO.class);
    private static final ParameterizedRowMapper<String> SAMPLE_COMPONENT_CODE_ROW_MAPPER = new ParameterizedRowMapper<String>(){

        public String mapRow(ResultSet rs, int rowNum) throws SQLException {
            return rs.getString("code");
        }
    };
    private static final ParameterizedRowMapper<SampleComponentDTO> SAMPLE_COMPONENT_ROW_MAPPER = new ParameterizedRowMapper<SampleComponentDTO>(){

        public SampleComponentDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            SampleComponentDTO sampleComponent = new SampleComponentDTO();
            sampleComponent.setId(new Long(rs.getLong("id")));
            sampleComponent.setCode(CodeConverter.tryToBusinessLayer(rs.getString("code")));
            sampleComponent.setSampleID(rs.getLong("samp_id"));
            MaterialBatchDTO materialBatch = new MaterialBatchDTO(null);
            materialBatch.setId(new Long(rs.getLong("mbid")));
            materialBatch.setCode(rs.getString("mbcode"));
            MaterialDTO material = new MaterialDTO(null);
            material.setId(new Long(rs.getLong("mid")));
            material.setCode(CodeConverter.tryToBusinessLayer(rs.getString("mcode")));
            long inhibitorOfId = rs.getLong("mate_id_inhibitor_of");
            if (!rs.wasNull()) {
                material.setInhibitorOfID(inhibitorOfId);
            }
            EntityTypeDTO materialType = new EntityTypeDTO();
            materialType.setId(new Long(rs.getLong("mtid")));
            materialType.setCode(CodeConverter.tryToBusinessLayer(rs.getString("mtcode")));
            materialType.setDescription(rs.getString("mtdescription"));
            material.setMaterialType(materialType);
            materialBatch.setMaterial(material);
            sampleComponent.setMaterialBatch(materialBatch);
            return sampleComponent;
        }
    };

    SampleComponentDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler) {
        super(dataSource, dtoValidatorStore, sequencerHandler);
    }

    @Override
    public final List<SampleComponentDTO> listSampleComponents(long sampleId) {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query("select sc.*, mb.id as mbid, mb.code as mbcode, m.id as mid, m.code as mcode, mate_id_inhibitor_of, mt.id as mtid, mt.code as mtcode, mt.description as mtdescription from sample_component_materials scma, material_batches mb, sample_components sc, samples s, material_types as mt, materials m where scma.maba_id = mb.id and mb.mate_id = m.id and scma.saco_id = sc.id and sc.samp_id = s.id and m.maty_id = mt.id and s.id = ?", SAMPLE_COMPONENT_ROW_MAPPER, new Object[]{sampleId});
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.valueOf(list.size()) + " sample component(s) have been found for sample id '" + sampleId + "'.");
        }
        return list;
    }

    @Override
    public void createSampleComponent(SampleComponentDTO component) {
        assert (component != null) : "Missing sample component.";
        String mangledCode = CodeConverter.tryToDatabase(component.getCode());
        assert (mangledCode != null) : "Missing sample component code.";
        Long sampleId = component.getSampleID();
        assert (sampleId != null) : "Missing sample id.";
        MaterialBatchDTO materialBatch = component.getMaterialBatch();
        assert (materialBatch != null) : "Missing material batch.";
        Long mabaId = materialBatch.getId();
        assert (mabaId != null) : "Missing material batch id.";
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        long sacoId = this.getNextValueOf("SAMPLE_COMPONENT_ID_SEQ");
        template.update("insert into sample_components (id, code, samp_id) values (?,?,?)", new Object[]{sacoId, mangledCode, sampleId});
        long id = this.getNextValueOf("SCMA_ID_SEQ");
        template.update("insert into sample_component_materials (id, saco_id, maba_id) values (?,?,?)", new Object[]{id, sacoId, mabaId});
        if (operationLog.isInfoEnabled()) {
            operationLog.info("ADD: sample component '" + mangledCode + "' for sample id " + sampleId + " and material batch id " + mabaId);
        }
        component.setId(sacoId);
    }

    @Override
    public final List<String> listSampleComponentCodes(long sampleId) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        List list = template.query("select sc.code from sample_components sc where sc.samp_id = ?", SAMPLE_COMPONENT_CODE_ROW_MAPPER, new Object[]{sampleId});
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.valueOf(list.size()) + " sample component code(s) have been found for sample id '" + sampleId + "'.");
        }
        return list;
    }
}

