/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractEntityDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dataaccess.db.InvalidationDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.SampleRowMapper;
import ch.systemsx.cisd.lims.server.dataaccess.db.SimpleSampleRowMapper;
import ch.systemsx.cisd.lims.server.dataaccess.db.properties.EntityPropertyValueRowMapper;
import ch.systemsx.cisd.lims.server.dto.EntityPropertyValueDTO;
import ch.systemsx.cisd.lims.server.dto.IEntityPropertiesHolderDTO;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SampleDAO
extends AbstractEntityDAO
implements ISampleDAO {
    private static final String SELECT_SAMPLE_WITH_BASICS = "select s.*, t.id as tid, t.code as tcode, t.description as tdescription, control_layout.code as control_layout_code ";
    private static final String SELECT = "select s.*, t.id as tid, t.code as tcode, t.description as tdescription, control_layout.code as control_layout_code , ps.id as pid, ps.user_id, ps.first_name, ps.last_name, ps.email, top.code as top_code, top.saty_id as top_tid, top.inva_id as top_inva_id, top_t.code as top_tcode, top_t.description as top_tdescription, parent.code as parent_code, parent.saty_id as parent_tid, parent.inva_id as parent_inva_id, parent_t.code as parent_tcode, parent_t.description as parent_tdescription, inv.id as inv_id, inv.pers_id_registerer as inv_registerer, inv.reason as inv_reason, inv.registration_timestamp as inv_date , invp.id as invp_pid, invp.user_id as invp_user_id, invp.first_name as invp_first_name, invp.last_name as invp_last_name, invp.email as invp_email ";
    private static final String FROM_SAMPLES = " from samples as s                                   join sample_types as t on t.id = s.saty_id left outer join samples as control_layout on s.samp_id_control_layout = control_layout.id ";
    private static final String TABLES_JOIN = String.valueOf(InvalidationDAO.getJoinWithInvalidationsOn("s.inva_id")) + " " + "join persons as ps on s.pers_id_registerer = ps.id " + "left outer join samples as top on s.samp_id_top = top.id " + "left outer join samples as parent on s.samp_id_generated_from = parent.id " + "left outer join sample_types as top_t on top_t.id = top.saty_id " + "left outer join sample_types as parent_t on parent_t.id = parent.saty_id ";
    private static final String TABLES_JOIN_PROC_EXP_PROJ = String.valueOf(TABLES_JOIN) + "left outer join sample_inputs as si on si.samp_id = s.id " + "left outer join procedures as p on si.proc_id = p.id " + "left join procedure_types as pcty on p.pcty_id = pcty.id " + "left join experiments as e on p.expe_id = e.id " + "left join projects as proj on e.proj_id = proj.id ";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, SampleDAO.class);
    private static final String SAMPLE_ID_SEQUENCE = "SAMPLE_ID_SEQ";
    private static final ParameterizedRowMapper<SampleDTO> SAMPLE_ROW_MAPPER = new SampleRowMapper();
    private static final ParameterizedRowMapper<SampleDTO> SAMPLE_WITH_BASICS_ROW_MAPPER = new SimpleSampleRowMapper();
    static final String ENTITY_PROPERTY_QUERY_TEMPLATE = "select sp.${fk_entity}, sp.${fk_entity_property_type}, sp.value, sp.pers_id_registerer, sp.cvte_id, cvt.code as cvterms_code from ${entity_property} sp left outer join controlled_vocabulary_terms cvt on sp.cvte_id = cvt.id";

    SampleDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler) {
        super(EntityKind.SAMPLE, dataSource, dtoValidatorStore, sequencerHandler);
    }

    private final long createID() {
        return this.getNextValueOf(SAMPLE_ID_SEQUENCE);
    }

    @Override
    public final List<SampleDTO> listSamplesByType(long sampleTypeId, long groupId) throws DataAccessException {
        String sql = "select s.*, t.id as tid, t.code as tcode, t.description as tdescription, control_layout.code as control_layout_code , ps.id as pid, ps.user_id, ps.first_name, ps.last_name, ps.email, top.code as top_code, top.saty_id as top_tid, top.inva_id as top_inva_id, top_t.code as top_tcode, top_t.description as top_tdescription, parent.code as parent_code, parent.saty_id as parent_tid, parent.inva_id as parent_inva_id, parent_t.code as parent_tcode, parent_t.description as parent_tdescription, inv.id as inv_id, inv.pers_id_registerer as inv_registerer, inv.reason as inv_reason, inv.registration_timestamp as inv_date , invp.id as invp_pid, invp.user_id as invp_user_id, invp.first_name as invp_first_name, invp.last_name as invp_last_name, invp.email as invp_email , si.proc_id as si_proc_id  from samples as s                                   join sample_types as t on t.id = s.saty_id left outer join samples as control_layout on s.samp_id_control_layout = control_layout.id " + TABLES_JOIN_PROC_EXP_PROJ + "where t.id = ? and (proj.grou_id = ? or proj.grou_id is null)";
        List list = this.getSimpleJdbcTemplate().query(sql, (ParameterizedRowMapper)SampleWithProcRowMapper.INSTANCE, new Object[]{sampleTypeId, groupId});
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d sample(s) have been found for sample type id %d and group id %d.", list.size(), sampleTypeId, groupId));
        }
        return list;
    }

    @Override
    public final List<SampleDTO> listSamplesByType(long sampleTypeId) throws DataAccessException {
        List list = this.getSimpleJdbcTemplate().query("select s.*, t.id as tid, t.code as tcode, t.description as tdescription, control_layout.code as control_layout_code , ps.id as pid, ps.user_id, ps.first_name, ps.last_name, ps.email, top.code as top_code, top.saty_id as top_tid, top.inva_id as top_inva_id, top_t.code as top_tcode, top_t.description as top_tdescription, parent.code as parent_code, parent.saty_id as parent_tid, parent.inva_id as parent_inva_id, parent_t.code as parent_tcode, parent_t.description as parent_tdescription, inv.id as inv_id, inv.pers_id_registerer as inv_registerer, inv.reason as inv_reason, inv.registration_timestamp as inv_date , invp.id as invp_pid, invp.user_id as invp_user_id, invp.first_name as invp_first_name, invp.last_name as invp_last_name, invp.email as invp_email  from samples as s                                   join sample_types as t on t.id = s.saty_id left outer join samples as control_layout on s.samp_id_control_layout = control_layout.id " + TABLES_JOIN + "where t.id = ?", SAMPLE_ROW_MAPPER, new Object[]{sampleTypeId});
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.valueOf(list.size()) + " sample(s) have been found for sample type id '" + sampleTypeId + "'.");
        }
        return list;
    }

    @Override
    public final List<SampleDTO> listSamplesAsInputs(long procedureId, String sampleTypeCode) throws DataAccessException {
        List list = this.getSimpleJdbcTemplate().query("select s.*, t.id as tid, t.code as tcode, t.description as tdescription, control_layout.code as control_layout_code , ps.id as pid, ps.user_id, ps.first_name, ps.last_name, ps.email, top.code as top_code, top.saty_id as top_tid, top.inva_id as top_inva_id, top_t.code as top_tcode, top_t.description as top_tdescription, parent.code as parent_code, parent.saty_id as parent_tid, parent.inva_id as parent_inva_id, parent_t.code as parent_tcode, parent_t.description as parent_tdescription, inv.id as inv_id, inv.pers_id_registerer as inv_registerer, inv.reason as inv_reason, inv.registration_timestamp as inv_date , invp.id as invp_pid, invp.user_id as invp_user_id, invp.first_name as invp_first_name, invp.last_name as invp_last_name, invp.email as invp_email  from samples as s                                   join sample_types as t on t.id = s.saty_id left outer join samples as control_layout on s.samp_id_control_layout = control_layout.id " + TABLES_JOIN + "left outer join sample_inputs as si on si.samp_id = s.id " + "where si.proc_id = ? and t.code = ?", SAMPLE_ROW_MAPPER, new Object[]{procedureId, CodeConverter.tryToDatabase(sampleTypeCode)});
        for (SampleDTO sample : list) {
            sample.setProcedureID(procedureId);
        }
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.valueOf(list.size()) + " sample(s) have been found for procedure id '" + procedureId + "'.");
        }
        return list;
    }

    @Override
    public final List<SampleDTO> listSampleByGeneratedFrom(long sampleId) throws DataAccessException {
        List samples = this.getSimpleJdbcTemplate().query("select s.*, t.id as tid, t.code as tcode, t.description as tdescription, control_layout.code as control_layout_code , ps.id as pid, ps.user_id, ps.first_name, ps.last_name, ps.email, top.code as top_code, top.saty_id as top_tid, top.inva_id as top_inva_id, top_t.code as top_tcode, top_t.description as top_tdescription, parent.code as parent_code, parent.saty_id as parent_tid, parent.inva_id as parent_inva_id, parent_t.code as parent_tcode, parent_t.description as parent_tdescription, inv.id as inv_id, inv.pers_id_registerer as inv_registerer, inv.reason as inv_reason, inv.registration_timestamp as inv_date , invp.id as invp_pid, invp.user_id as invp_user_id, invp.first_name as invp_first_name, invp.last_name as invp_last_name, invp.email as invp_email  from samples as s                                   join sample_types as t on t.id = s.saty_id left outer join samples as control_layout on s.samp_id_control_layout = control_layout.id " + TABLES_JOIN + "where s.samp_id_generated_from = ? order by s.code", SAMPLE_ROW_MAPPER, new Object[]{sampleId});
        return samples;
    }

    @Override
    public final List<SampleDTO> listAllSamples() throws DataAccessException {
        List samples = this.getSimpleJdbcTemplate().query("select s.*, t.id as tid, t.code as tcode, t.description as tdescription, control_layout.code as control_layout_code  from samples as s                                   join sample_types as t on t.id = s.saty_id left outer join samples as control_layout on s.samp_id_control_layout = control_layout.id ", SAMPLE_WITH_BASICS_ROW_MAPPER, new Object[0]);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.valueOf(samples.size()) + " sample(s) have been found.");
        }
        return samples;
    }

    @Override
    public final Long tryFindSampleIdByCode(String code) {
        return this.tryFindId("select id from samples where code = ?", CodeConverter.tryToDatabase(code));
    }

    @Override
    public String getSampleCodeById(Long sampleId) throws DataAccessException {
        return this.getCode("select code from samples where id = ?", sampleId);
    }

    private SampleDTO tryEnsureOneSample(String sampleCriteria, List<SampleDTO> list) {
        if (list.size() == 0) {
            if (operationLog.isDebugEnabled()) {
                operationLog.debug("No sample has been found for sample '" + sampleCriteria + "'.");
            }
            return null;
        }
        assert (list.size() == 1) : "Expected only one sample: " + list;
        SampleDTO sample = list.get(0);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("Following sample '" + sample + "' has been found for sample '" + sampleCriteria + "'.");
        }
        return sample;
    }

    @Override
    public SampleDTO tryFindSampleByCode(String code) throws DataAccessException {
        assert (code != null) : "Given code can not be null.";
        String mangledCode = CodeConverter.tryToDatabase(code);
        List list = this.getSimpleJdbcTemplate().query("select s.*, t.id as tid, t.code as tcode, t.description as tdescription, control_layout.code as control_layout_code , ps.id as pid, ps.user_id, ps.first_name, ps.last_name, ps.email, top.code as top_code, top.saty_id as top_tid, top.inva_id as top_inva_id, top_t.code as top_tcode, top_t.description as top_tdescription, parent.code as parent_code, parent.saty_id as parent_tid, parent.inva_id as parent_inva_id, parent_t.code as parent_tcode, parent_t.description as parent_tdescription, inv.id as inv_id, inv.pers_id_registerer as inv_registerer, inv.reason as inv_reason, inv.registration_timestamp as inv_date , invp.id as invp_pid, invp.user_id as invp_user_id, invp.first_name as invp_first_name, invp.last_name as invp_last_name, invp.email as invp_email  from samples as s                                   join sample_types as t on t.id = s.saty_id left outer join samples as control_layout on s.samp_id_control_layout = control_layout.id " + TABLES_JOIN + "where s.code = ?", SAMPLE_ROW_MAPPER, new Object[]{mangledCode});
        return this.tryEnsureOneSample(mangledCode, list);
    }

    @Override
    public SampleDTO tryFindSampleById(long id) throws DataAccessException {
        List list = this.getSimpleJdbcTemplate().query("select s.*, t.id as tid, t.code as tcode, t.description as tdescription, control_layout.code as control_layout_code , ps.id as pid, ps.user_id, ps.first_name, ps.last_name, ps.email, top.code as top_code, top.saty_id as top_tid, top.inva_id as top_inva_id, top_t.code as top_tcode, top_t.description as top_tdescription, parent.code as parent_code, parent.saty_id as parent_tid, parent.inva_id as parent_inva_id, parent_t.code as parent_tcode, parent_t.description as parent_tdescription, inv.id as inv_id, inv.pers_id_registerer as inv_registerer, inv.reason as inv_reason, inv.registration_timestamp as inv_date , invp.id as invp_pid, invp.user_id as invp_user_id, invp.first_name as invp_first_name, invp.last_name as invp_last_name, invp.email as invp_email  from samples as s                                   join sample_types as t on t.id = s.saty_id left outer join samples as control_layout on s.samp_id_control_layout = control_layout.id " + TABLES_JOIN + "where s.id = ?", SAMPLE_ROW_MAPPER, new Object[]{id});
        return this.tryEnsureOneSample("" + id, list);
    }

    @Override
    public final void createSample(SampleDTO sample) throws DataAccessException {
        assert (sample != null);
        assert (sample.getSampleType() != null);
        this.validateDTO(sample);
        long id = this.createID();
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("insert into samples (id, code, saty_id, samp_id_top, samp_id_generated_from, pers_id_registerer, samp_id_control_layout) values (?,?,?,?,?,?,?)", new Object[]{id, CodeConverter.tryToDatabase(sample.getCode()), sample.getSampleType().getId(), sample.getTopID(), sample.getGeneratedFromID(), sample.getRegistratorID(), sample.getControlLayoutId()});
        sample.setId(id);
    }

    @Override
    public void createSampleInput(Long sampleId, Long procedureId) throws DataAccessException {
        assert (sampleId != null) : "Missing sample id.";
        assert (procedureId != null) : "Missing procedure id.";
        long id = this.getNextValueOf("SAMPLE_INPUT_ID_SEQ");
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("insert into sample_inputs (id, samp_id, proc_id) values (?,?,?)", new Object[]{id, sampleId, procedureId});
        if (operationLog.isInfoEnabled()) {
            operationLog.info("ADD: connection between sample [id=" + sampleId + "] and procedure [id=" + procedureId + "].");
        }
    }

    @Override
    public final void updateSampleAscendants(SampleDTO sample) throws DataAccessException {
        assert (sample != null);
        this.validateDTO(sample);
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("update samples set samp_id_top = ?, samp_id_generated_from = ? where id = ?", new Object[]{sample.getTopID(), sample.getGeneratedFromID(), sample.getId()});
    }

    @Override
    public boolean updateSampleInvalidation(Long sampleId, long invalidationId) {
        assert (sampleId != null);
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        int affectedRows = template.update("update samples set inva_id = ? where id = ? and inva_id is null", new Object[]{invalidationId, sampleId});
        assert (affectedRows <= 1) : "Expected at most one sample, but found " + affectedRows;
        return affectedRows == 1;
    }

    @Override
    public final List<IEntityPropertiesHolderDTO> listAllEntityProperties() throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        String sql = this.createPropertiesSql(ENTITY_PROPERTY_QUERY_TEMPLATE);
        EntityPropertyValueRowMapper mapper = new EntityPropertyValueRowMapper(this.entityPropertyTableNames);
        template.query(sql, (ParameterizedRowMapper)mapper, new Object[0]);
        List<IEntityPropertiesHolderDTO> list = mapper.getEntityPropertiesHolders();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d plate property holder(s) has(have) been found.", list.size()));
        }
        return list;
    }

    @Override
    public final List<EntityPropertyValueDTO> listEntityProperties(long entityId) throws DataAccessException {
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        String sql = this.createPropertiesSql("select sp.${fk_entity}, sp.${fk_entity_property_type}, sp.value, sp.pers_id_registerer, sp.cvte_id, cvt.code as cvterms_code from ${entity_property} sp left outer join controlled_vocabulary_terms cvt on sp.cvte_id = cvt.id where ${fk_entity} = ?");
        EntityPropertyValueRowMapper mapper = new EntityPropertyValueRowMapper(this.entityPropertyTableNames);
        List list = template.query(sql, (ParameterizedRowMapper)mapper, new Object[]{entityId});
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d plate property(ies) has(have) been found for plate id %d.", list.size(), entityId));
        }
        return list;
    }

    private static final class SampleWithProcRowMapper
    extends SampleRowMapper {
        static final SampleWithProcRowMapper INSTANCE = new SampleWithProcRowMapper();

        private SampleWithProcRowMapper() {
        }

        public final SampleDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            SampleDTO sample = super.mapRow(rs, rowNum);
            long procedureID = rs.getLong("si_proc_id");
            if (!rs.wasNull()) {
                sample.setProcedureID(procedureID);
            }
            return sample;
        }
    }
}

