/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IVocabularyDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dataaccess.db.InvalidationDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.PersonDAO;
import ch.systemsx.cisd.lims.server.dto.PersonDTO;
import ch.systemsx.cisd.lims.server.dto.VocabularyDTO;
import ch.systemsx.cisd.lims.server.dto.VocabularyTermDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VocabularyDAO
extends AbstractDAO
implements IVocabularyDAO {
    private static final String ID_SEQUENCE = "CONTROLLED_VOCABULARY_ID_SEQ";
    private static final String TERM_ID_SEQUENCE = "CVTE_ID_SEQ";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, InvalidationDAO.class);
    private static final String SELECT_VOCABULARIES_WITH_WHERE = "select v.id, v.code, v.description, v.pers_id_registerer, v.registration_timestamp, v.is_managed_internally, v.is_internal_namespace,  p.id as pid, p.user_id, p.first_name, p.last_name, p.email  from controlled_vocabularies as v, persons as p where v.pers_id_registerer = p.id";
    private static final ParameterizedRowMapper<VocabularyDTO> VOCABULARY_MAPPER = new ParameterizedRowMapper<VocabularyDTO>(){

        public final VocabularyDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            PersonDTO person = PersonDAO.fillPersonFromResultSet(rs);
            boolean internalNamespace = rs.getBoolean("is_internal_namespace");
            String code = CodeConverter.tryToBusinessLayer(rs.getString("code"), !internalNamespace);
            String description = rs.getString("description");
            Long registratorId = rs.getLong("pers_id_registerer");
            VocabularyDTO vocabulary = new VocabularyDTO(code, description, registratorId);
            vocabulary.setId(rs.getLong("id"));
            vocabulary.setRegistrationDate(new Date(rs.getTimestamp("registration_timestamp").getTime()));
            vocabulary.setRegistrator(person);
            vocabulary.setManagedInternally(rs.getBoolean("is_managed_internally"));
            vocabulary.setInternalNamespace(internalNamespace);
            return vocabulary;
        }
    };
    private static final ParameterizedRowMapper<VocabularyTermDTO> VOCABULARY_TERM_MAPPER = new ParameterizedRowMapper<VocabularyTermDTO>(){

        public final VocabularyTermDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            PersonDTO person = PersonDAO.fillPersonFromResultSet(rs);
            String code = CodeConverter.tryToBusinessLayer(rs.getString("code"));
            Long controlledVocabularyId = rs.getLong("covo_id");
            Long registratorId = rs.getLong("pers_id_registerer");
            VocabularyTermDTO vocabularyTerm = new VocabularyTermDTO(code, controlledVocabularyId, registratorId);
            vocabularyTerm.setId(rs.getLong("id"));
            vocabularyTerm.setRegistrationDate(new Date(rs.getTimestamp("registration_timestamp").getTime()));
            vocabularyTerm.setRegistrator(person);
            return vocabularyTerm;
        }
    };

    VocabularyDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler) {
        super(dataSource, dtoValidatorStore, sequencerHandler);
    }

    private final long createID() {
        return this.getNextValueOf(ID_SEQUENCE);
    }

    private final long createTermID() {
        return this.getNextValueOf(TERM_ID_SEQUENCE);
    }

    @Override
    public final void create(VocabularyDTO vocabulary) {
        assert (vocabulary != null) : "Given vocabulary can not be null.";
        this.validateDTO(vocabulary);
        String mangledVocabularyCode = CodeConverter.tryToDatabase(vocabulary.getCode());
        long id = this.createID();
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("insert into controlled_vocabularies (id, code, description, pers_id_registerer) values (?,?,?, ?)", new Object[]{id, mangledVocabularyCode, vocabulary.getDescription(), vocabulary.getRegistratorID()});
        vocabulary.setId(id);
    }

    @Override
    public void createTerm(VocabularyTermDTO vocabularyTerm) {
        assert (vocabularyTerm != null) : "Given vocabulary term can not be null.";
        this.validateDTO(vocabularyTerm);
        String mangledVocabularyCode = CodeConverter.tryToDatabase(vocabularyTerm.getCode());
        long id = this.createTermID();
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("insert into controlled_vocabulary_terms (id, code, covo_id, pers_id_registerer) values (?,?,?,?)", new Object[]{id, mangledVocabularyCode, vocabularyTerm.getVocabularyId(), vocabularyTerm.getRegistratorID()});
        vocabularyTerm.setId(id);
    }

    @Override
    public final VocabularyDTO tryFindByCode(String vocabularyCode) {
        String mangledVocabularyCode = CodeConverter.tryToDatabase(vocabularyCode);
        boolean internalNamespace = CodeConverter.isInternalNamespace(vocabularyCode);
        List list = this.getSimpleJdbcTemplate().query("select v.id, v.code, v.description, v.pers_id_registerer, v.registration_timestamp, v.is_managed_internally, v.is_internal_namespace,  p.id as pid, p.user_id, p.first_name, p.last_name, p.email  from controlled_vocabularies as v, persons as p where v.pers_id_registerer = p.id and v.is_internal_namespace = ? and code = ?", VOCABULARY_MAPPER, new Object[]{internalNamespace, mangledVocabularyCode});
        if (operationLog.isDebugEnabled()) {
            operationLog.debug("Number of vocabularies with code " + mangledVocabularyCode + " found: " + list.size());
        }
        if (list.size() == 0) {
            return null;
        }
        assert (list.size() == 1) : "Expected only one vocabulary: " + list;
        return (VocabularyDTO)list.get(0);
    }

    @Override
    public final List<VocabularyDTO> listVocabularies() {
        List list = this.getSimpleJdbcTemplate().query("select v.id, v.code, v.description, v.pers_id_registerer, v.registration_timestamp, v.is_managed_internally, v.is_internal_namespace,  p.id as pid, p.user_id, p.first_name, p.last_name, p.email  from controlled_vocabularies as v, persons as p where v.pers_id_registerer = p.id and v.is_internal_namespace = false", VOCABULARY_MAPPER, new Object[0]);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.valueOf(list.size()) + " vocabulary(ies) have been found.");
        }
        return list;
    }

    @Override
    public final List<VocabularyTermDTO> listVocabularyTerms(String vocabularyCode) {
        assert (vocabularyCode != null) : "Vocabulary code can not be null.";
        String mangledVocabularyCode = CodeConverter.tryToDatabase(vocabularyCode);
        boolean internalNamespace = CodeConverter.isInternalNamespace(vocabularyCode);
        List list = this.getSimpleJdbcTemplate().query("select vt.id, vt.code, vt.covo_id, vt.pers_id_registerer, vt.registration_timestamp,  p.id as pid, p.user_id, p.first_name, p.last_name, p.email  from controlled_vocabulary_terms as vt, persons as p, controlled_vocabularies as v  where v.pers_id_registerer = p.id and vt.covo_id = v.id and v.is_internal_namespace = ? and v.code = ?", VOCABULARY_TERM_MAPPER, new Object[]{internalNamespace, mangledVocabularyCode});
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.valueOf(list.size()) + " vocabulary term(s) for vocabulary code '" + mangledVocabularyCode + "'.");
        }
        return list;
    }
}

