/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db.properties;

import ch.systemsx.cisd.lims.server.dataaccess.db.properties.EntityPropertiesMerger;
import ch.systemsx.cisd.lims.server.dataaccess.db.properties.EntityPropertyTableNames;
import ch.systemsx.cisd.lims.server.dataaccess.db.properties.EntityPropertyValueRowMapper;
import ch.systemsx.cisd.lims.server.dataaccess.db.properties.IEntityPropertiesGetter;
import ch.systemsx.cisd.lims.server.dto.IEntityPropertiesHolderDTO;
import java.util.List;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityWithPropertiesFetcher<ET extends IEntityPropertiesHolderDTO> {
    private final String selectEntity;
    private final String selectProperties;
    private final ParameterizedRowMapper<ET> mapper;
    private final EntityPropertyTableNames entityPropertyTableNames;
    private final SimpleJdbcTemplate template;

    public EntityWithPropertiesFetcher(String selectEntity, String selectProperties, ParameterizedRowMapper<ET> mapper, EntityPropertyTableNames entityPropertyTableNames, SimpleJdbcTemplate template) {
        this.selectEntity = selectEntity;
        this.selectProperties = selectProperties;
        this.mapper = mapper;
        this.entityPropertyTableNames = entityPropertyTableNames;
        this.template = template;
    }

    private final List<ET> executeFetchEntities() {
        return this.template.query(this.selectEntity, this.mapper, new Object[0]);
    }

    private final IEntityPropertiesGetter executeFetchProperties() {
        EntityPropertyValueRowMapper propertyRowMapper = new EntityPropertyValueRowMapper(this.entityPropertyTableNames);
        this.template.query(this.selectProperties, (ParameterizedRowMapper)propertyRowMapper, new Object[0]);
        return propertyRowMapper;
    }

    public final List<ET> execute() {
        List<ET> entities = this.executeFetchEntities();
        IEntityPropertiesGetter propertiesGetter = this.executeFetchProperties();
        EntityPropertiesMerger.setProperties(entities, propertiesGetter);
        return entities;
    }

    public final ET executeForObject() {
        IEntityPropertiesHolderDTO entity = (IEntityPropertiesHolderDTO)this.template.queryForObject(this.selectEntity, this.mapper, new Object[0]);
        IEntityPropertiesGetter propertiesGetter = this.executeFetchProperties();
        EntityPropertiesMerger.setProperties(entity, propertiesGetter);
        return (ET)entity;
    }
}

