/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dto;

import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.server.dto.AbstractEntity;
import ch.systemsx.cisd.lims.server.dto.EntityTypeDTO;
import ch.systemsx.cisd.lims.server.dto.ExperimentTypeDTO;
import ch.systemsx.cisd.lims.server.dto.IInvalidationHolder;
import ch.systemsx.cisd.lims.server.dto.InvalidationDTO;
import ch.systemsx.cisd.lims.server.dto.MaterialDTO;
import ch.systemsx.cisd.lims.server.dto.ProjectDTO;
import java.util.Date;

public abstract class AbstractExperimentDTO
extends AbstractEntity
implements IInvalidationHolder {
    private Long projectID;
    private ProjectDTO project;
    private Long studyObjectID;
    private MaterialDTO studyObject;
    private Date registrationDate;
    private Long experimentTypeID;
    private ExperimentTypeDTO experimentType;
    private Long invalidationID;
    private InvalidationDTO invalidation;
    private SimpleEntityProperty[] simpleProperties;

    public AbstractExperimentDTO(Long registratorID) {
        super(registratorID);
    }

    public final Long getProjectID() {
        return this.projectID;
    }

    public final void setProjectID(Long projectID) {
        assert (this.project == null) : "Project already defined.";
        this.projectID = projectID;
    }

    public final ProjectDTO getProject() {
        return this.project;
    }

    public final void setProject(ProjectDTO project) {
        this.projectID = AbstractExperimentDTO.getAndCheckID(project, this.projectID);
        this.project = project;
    }

    public final Long getStudyObjectID() {
        return this.studyObjectID;
    }

    public final void setStudyObjectID(Long studyObjectID) {
        assert (this.studyObject == null) : "Study object already defined.";
        this.studyObjectID = studyObjectID;
    }

    public final MaterialDTO getStudyObject() {
        return this.studyObject;
    }

    public final void setStudyObject(MaterialDTO studyObject) {
        this.studyObjectID = AbstractExperimentDTO.getAndCheckID(studyObject, this.studyObjectID);
        this.studyObject = studyObject;
    }

    public final Date getRegistrationDate() {
        return this.registrationDate;
    }

    public final void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    public final Long getExperimentTypeID() {
        return this.experimentTypeID;
    }

    public final void setExperimentTypeID(Long experimentTypeID) {
        assert (this.experimentType == null) : "Experiment type already defined.";
        this.experimentTypeID = experimentTypeID;
    }

    public final ExperimentTypeDTO getExperimentType() {
        return this.experimentType;
    }

    public final SimpleEntityProperty[] getSimpleProperties() {
        return this.simpleProperties;
    }

    public final void setSimpleProperties(SimpleEntityProperty[] simpleProperties) {
        this.simpleProperties = simpleProperties;
    }

    public final void setExperimentType(ExperimentTypeDTO experimentType) {
        this.experimentTypeID = AbstractExperimentDTO.getAndCheckID(experimentType, this.experimentTypeID);
        this.experimentType = experimentType;
    }

    public final void setInvalidationId(Long invalidationID) {
        assert (this.invalidation == null) : "Invalidation already defined.";
        this.invalidationID = invalidationID;
    }

    public final EntityTypeDTO getEntityType() {
        return this.getExperimentType();
    }

    public final Long getInvalidationId() {
        return this.invalidationID;
    }

    public final InvalidationDTO getInvalidation() {
        return this.invalidation;
    }

    public final void setInvalidation(InvalidationDTO invalidation) {
        this.invalidationID = AbstractExperimentDTO.getAndCheckID(invalidation, this.invalidationID);
        this.invalidation = invalidation;
    }
}

