/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dto;

import ch.systemsx.cisd.lims.server.dto.AbstractRegistratorHolder;
import ch.systemsx.cisd.lims.server.dto.DataTypeDTO;
import java.util.Date;

public final class PropertyTypeDTO
extends AbstractRegistratorHolder {
    private String code;
    private DataTypeDTO type;
    private String description;
    private String userLabel;
    private final Long typeId;
    private String vocabularyCodeOrNull;
    private Long vocabularyIdOrNull;
    private boolean internalNamespace;
    private boolean managedInternally;
    private Date registrationDate;

    public PropertyTypeDTO(Long registratorID, Long typeId, Long vocabularyIdOrNull) {
        super(registratorID);
        assert (typeId != null) : "Data type id can not be null.";
        this.typeId = typeId;
        this.vocabularyIdOrNull = vocabularyIdOrNull;
    }

    public final String getCode() {
        return this.code;
    }

    public final void setCode(String name) {
        this.code = name;
    }

    public final DataTypeDTO getType() {
        return this.type;
    }

    public final void setType(DataTypeDTO type) {
        PropertyTypeDTO.getAndCheckID(type, this.typeId);
        this.type = type;
    }

    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final String getUserLabel() {
        return this.userLabel;
    }

    public final void setUserLabel(String userLabel) {
        this.userLabel = userLabel;
    }

    public final Long getTypeId() {
        return this.typeId;
    }

    public final Date getRegistrationDate() {
        return this.registrationDate;
    }

    public final void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    public String getVocabularyCode() {
        return this.vocabularyCodeOrNull;
    }

    public void setVocabularyCode(String vocabularyCode) {
        this.vocabularyCodeOrNull = vocabularyCode;
    }

    public Long getVocabularyId() {
        return this.vocabularyIdOrNull;
    }

    public boolean isManagedInternally() {
        return this.managedInternally;
    }

    public void setManagedInternally(boolean managedInternally) {
        this.managedInternally = managedInternally;
    }

    public boolean isInternalNamespace() {
        return this.internalNamespace;
    }

    public void setInternalNamespace(boolean internalNamespace) {
        this.internalNamespace = internalNamespace;
    }

    public final void describe(StringBuilder builder) {
        builder.append("Property type '").append(this.code).append("'");
    }
}

