/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dto;

import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SampleGenerationDTO {
    private final SampleDTO generator;
    private final SampleDTO[] generated;

    public SampleGenerationDTO(SampleDTO generator, List<SampleDTO> generated) {
        assert (generator != null) : "Generator can not be null.";
        assert (generated != null) : "Generated can not be null.";
        assert (SampleGenerationDTO.areRelated(generator, generated)) : "Generator and generated are not related.";
        this.generator = generator;
        this.generated = generated.toArray(SampleDTO.EMPTY_ARRAY);
    }

    private static final boolean areRelated(SampleDTO generator, List<SampleDTO> generated) {
        for (SampleDTO child : generated) {
            SampleDTO generatedFrom = child.getGeneratedFrom();
            assert (generatedFrom != null);
            if (generatedFrom.getId().equals(generator.getId())) continue;
            return false;
        }
        return true;
    }

    public final SampleDTO[] getGenerated() {
        return this.generated;
    }

    public final SampleDTO getGenerator() {
        return this.generator;
    }
}

