/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.workflow.threev;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.server.business.AbstractScreeningProcessStrategy;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.lims.server.business.bo.ISampleBO;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dto.ExperimentDTO;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;

final class ScreeningProcessStrategy
extends AbstractScreeningProcessStrategy {
    ScreeningProcessStrategy(IDAOFactory daoFactory, IBusinessObjectFactory boFactory, Session session) {
        super(daoFactory, boFactory, session);
    }

    private final ISampleBO findScreenableSampleByCode(String sampleCode) {
        ISampleBO sampleBO = this.boFactory.createSampleBO(this.session);
        sampleBO.loadBySampleCode(sampleCode);
        SampleDTO sample = sampleBO.getSample();
        assert (sample != null);
        if (sample.getInvalidation() != null) {
            throw UserFailureException.fromTemplate("Given sample '%s' is invalid.", sampleCode);
        }
        String type = sample.getSampleType().getCode();
        if (!type.equals(SampleTypeCode.CELL_PLATE.getCode()) && !type.equals(SampleTypeCode.REINFECT_PLATE.getCode())) {
            throw UserFailureException.fromTemplate("Given sample '%s' has the wrong type. Only samples of types '%s' or '%s' are accepted here.", sample.getCode(), SampleTypeCode.CELL_PLATE.getCode(), SampleTypeCode.REINFECT_PLATE.getCode());
        }
        return sampleBO;
    }

    public final void registerPlatesOnExperimentRegistration(String[] cellOrReinfectionPlates, String controlLayoutCodeOrNull, Long procedureId) {
        assert (cellOrReinfectionPlates != null);
        assert (procedureId != null);
        if (controlLayoutCodeOrNull != null) {
            throw UserFailureException.fromTemplate("Control layout must not be specified for the experiment in this workflow. Attach control layout to the plate!", new Object[0]);
        }
        if (cellOrReinfectionPlates.length == 0) {
            throw UserFailureException.fromTemplate("No cell plate(s) have been specified.", new Object[0]);
        }
        String[] stringArray = cellOrReinfectionPlates;
        int n = cellOrReinfectionPlates.length;
        int n2 = 0;
        while (n2 < n) {
            String cellOrReinfectionPlate = stringArray[n2];
            this.registerCellPlatesOnExperimentRegistration(cellOrReinfectionPlate, procedureId);
            ++n2;
        }
    }

    final void registerCellPlatesOnExperimentRegistration(String cellOrReinfectionPlateTypeCode, long procedureId) {
        ISampleBO sampleBO = this.findScreenableSampleByCode(cellOrReinfectionPlateTypeCode);
        SampleDTO sample = sampleBO.getSample();
        this.checkSampleUsableInExperiment(procedureId, sampleBO, sample);
        sampleBO.createSampleInputLinkForProcedure(procedureId);
        this.daoFactory.getSampleDAO().updateSampleAscendants(sample);
    }

    private void checkSampleUsableInExperiment(long procedureId, ISampleBO sampleBO, SampleDTO sample) {
        this.checkSampleUnused(sample, procedureId);
        this.checkSampleWithoutDatasets(sampleBO);
    }

    private void checkSampleWithoutDatasets(ISampleBO sampleBO) {
        if (sampleBO.hasDatasets()) {
            throw UserFailureException.fromTemplate("Cannot use sample '%s' in the experiment, because in the previous invalidated experiment there were some data acquired for this sample.", sampleBO.getSample().getCode());
        }
    }

    private void checkSampleUnused(SampleDTO sample, long allowedProcedureId) {
        Long curProcedureId = sample.getProcedureID();
        if (curProcedureId != null && !curProcedureId.equals(allowedProcedureId)) {
            throw this.createSampleAlreadyRegisteredException(sample, curProcedureId);
        }
    }

    private UserFailureException createSampleAlreadyRegisteredException(SampleDTO sample, Long curProcedureId) {
        ExperimentDTO other = this.daoFactory.getExperimentDAO().getExperimentByProcedureId(curProcedureId);
        ExperimentIdentifier experimentIdentifier = new ExperimentIdentifier(other.getProject().getCode(), other.getCode());
        experimentIdentifier.setGroupCode(other.getProject().getGroup().getCode());
        return UserFailureException.fromTemplate("Given sample code '%s' already registered for experiment '%s'.", sample.getCode(), experimentIdentifier);
    }

    public final SampleDTO getOrCreateCellPlateForDataSet(String barCode, Long procedureID) {
        assert (barCode != null);
        return this.findScreenableSampleByCode(barCode).getSample();
    }

    public ExperimentDTO getExperiment(ExperimentIdentifier experimentId, String sampleCode) throws UserFailureException {
        assert (sampleCode != null);
        SampleDTO cellPlate = this.findScreenableSampleByCode(sampleCode).getSample();
        Long procedureId = cellPlate.getProcedureID();
        if (procedureId == null) {
            throw UserFailureException.fromTemplate("No procedure has been specified for cell plate '%s'.", cellPlate.getCode());
        }
        return this.daoFactory.getExperimentDAO().getExperimentByProcedureId(procedureId);
    }

    public SampleDTO tryToGetTopSampleRegisteredFor(String sampleCode) throws UserFailureException {
        SampleDTO sample = this.daoFactory.getSampleDAO().tryFindSampleByCode(sampleCode);
        if (sample == null) {
            return null;
        }
        SampleDTO top = sample.getTop();
        assert (top != null) : "Top sample not loaded.";
        return this.enrichWithProperties(top);
    }
}

