/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.ModelBasedGrid;
import ch.systemsx.cisd.lims.webclient.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.lims.webclient.client.dto.Column;
import com.gwtext.client.core.Ext;
import com.gwtext.client.data.ArrayReader;
import com.gwtext.client.data.DataProxy;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.PagingMemoryProxy;
import com.gwtext.client.data.Reader;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.Grid;
import java.util.List;

public final class ColumnGrid
extends Grid {
    public ColumnGrid(Column[] columns, List columnsWithLinks, String height, boolean sortable) {
        super(Ext.generateId(), null, height, ColumnGrid.createStore(columns), ColumnGrid.createColumnModel(columns, columnsWithLinks, sortable), ModelBasedGrid.createGridConfig());
        this.getSelectionModel().lock();
        this.render();
    }

    private static final Store createStore(Column[] columns) {
        FieldDef[] fieldDefinitions = new FieldDef[columns.length];
        int numberOfRows = 0;
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            fieldDefinitions[i] = new StringFieldDef(column.getTitle());
            numberOfRows = Math.max(numberOfRows, column.getValues().length);
            ++i;
        }
        RecordDef recordDef = new RecordDef(fieldDefinitions);
        Object[][] data = new Object[numberOfRows][columns.length];
        int rowIndex = 0;
        while (rowIndex < numberOfRows) {
            data[rowIndex] = new Object[columns.length];
            int columnIndex = 0;
            while (columnIndex < columns.length) {
                String value = columns[columnIndex].getValues()[rowIndex];
                data[rowIndex][columnIndex] = value;
                ++columnIndex;
            }
            ++rowIndex;
        }
        return new Store((DataProxy)new PagingMemoryProxy(data), (Reader)new ArrayReader(recordDef));
    }

    private static ColumnModel createColumnModel(Column[] columns, List columnsWithLinks, boolean sortable) {
        ColumnConfig[] configs = new ColumnConfig[columns.length];
        int i = 0;
        while (i < columns.length) {
            configs[i] = ColumnGrid.createColumnConfig(columns[i], columnsWithLinks, sortable);
            ++i;
        }
        return new ColumnModel(configs);
    }

    private static ColumnConfig createColumnConfig(Column column, List columnsWithLinks, boolean sortable) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(column.getTitle());
        config.setSortable(sortable);
        config.setWidth(column.getTitle().equals("sequence") ? 200 : 100);
        config.setDataIndex(column.getTitle());
        if (columnsWithLinks.contains(column.getTitle())) {
            config.setRenderer(LinkRenderer.LINK_RENDERER);
        }
        return config;
    }
}

