/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.ColumnConfigs;
import ch.systemsx.cisd.lims.webclient.client.application.FilePropertyGrid;
import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import ch.systemsx.cisd.lims.webclient.client.application.renderer.RegistrationDateRenderer;
import ch.systemsx.cisd.lims.webclient.client.application.ui.AbstractLayoutDialog;
import ch.systemsx.cisd.lims.webclient.client.dto.ExternalData;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.Ext;
import com.gwtext.client.data.DateFieldDef;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.SimpleStore;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.Grid;
import java.util.ArrayList;

public final class ExternalDataDialog
extends AbstractLayoutDialog {
    private static final String CODE = "code";
    private static final String PROCEDURE_TYPE = "procedureType";
    private static final String IS_COMPLETE = "isComplete";
    private static final String TIMESTAMP = "measurementTimestamp";
    private static final String LOCATION = "location";
    private static final String LOCATOR_TYPE = "locatorType";
    private static final String FILE_FORMAT_TYPE = "fileFormatType";
    private static final String OBSERVABLE_TYPE = "observableType";
    private static final String PARENT_DATASET = "parentDataset";
    private static final String DATA_PRODUCER = "dataProducer";
    private final ExternalData[] externalDatas;

    public ExternalDataDialog(String title, ExternalData[] externalDatas, IMessageResources messageResources) {
        super(messageResources, title, 650, 300);
        this.externalDatas = externalDatas;
        this.addContentPanel();
    }

    protected final Widget createContentWidget() {
        Grid grid = new Grid(Ext.generateId(), null, this.externalDatas.length < 2 ? "150px" : null, ExternalDataDialog.createStore(this.externalDatas, this.messageResources), ExternalDataDialog.createColumnModel(this.messageResources), FilePropertyGrid.createGridConfig());
        grid.render();
        return grid;
    }

    private static final ColumnModel createColumnModel(IMessageResources messageResources) {
        ColumnModel columnModel = new ColumnModel(ExternalDataDialog.createColumnConfigs(messageResources));
        return columnModel;
    }

    private static final ColumnConfig[] createColumnConfigs(IMessageResources messageResources) {
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
        configs.add(ExternalDataDialog.createCodeColumnConfig(messageResources));
        configs.add(ExternalDataDialog.createProcedureTypeColumnConfig(messageResources));
        configs.add(ExternalDataDialog.createIsCompleteColumnConfig(messageResources));
        configs.add(ExternalDataDialog.createObservableTypeColumnConfig(messageResources));
        configs.add(ExternalDataDialog.createFileFormatTypeColumnConfig(messageResources));
        configs.add(ColumnConfigs.createRegistrationDateColumnConfig(messageResources));
        configs.add(ExternalDataDialog.createLocationColumnConfig(messageResources));
        configs.add(ExternalDataDialog.createLocatorTypeColumnConfig(messageResources));
        configs.add(ExternalDataDialog.createMeasurementTimestampColumnConfig(messageResources));
        configs.add(ExternalDataDialog.createParentDatasetColumnConfig(messageResources));
        configs.add(ExternalDataDialog.createDataProducerColumnConfig(messageResources));
        return configs.toArray(new ColumnConfig[configs.size()]);
    }

    private static ColumnConfig createFileFormatTypeColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getExternalDataFileFormatTypeLabel());
        config.setSortable(true);
        config.setWidth(120);
        config.setDataIndex(FILE_FORMAT_TYPE);
        return config;
    }

    private static ColumnConfig createLocatorTypeColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getExternalDataLocatorTypeLabel());
        config.setSortable(true);
        config.setWidth(130);
        config.setDataIndex(LOCATOR_TYPE);
        return config;
    }

    private static ColumnConfig createCodeColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getExternalDataCodeLabel());
        config.setSortable(true);
        config.setWidth(150);
        config.setDataIndex(CODE);
        return config;
    }

    private static ColumnConfig createProcedureTypeColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getExternalDataProcedureTypeLabel());
        config.setSortable(true);
        config.setWidth(140);
        config.setDataIndex(PROCEDURE_TYPE);
        return config;
    }

    private static ColumnConfig createIsCompleteColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getExternalDataIsCompleteLabel());
        config.setSortable(true);
        config.setWidth(100);
        config.setDataIndex(IS_COMPLETE);
        return config;
    }

    private static ColumnConfig createLocationColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getExternalDataLocationLabel());
        config.setSortable(true);
        config.setWidth(120);
        config.setDataIndex(LOCATION);
        return config;
    }

    private static final ColumnConfig createObservableTypeColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getExternalDataObservableTypeLabel());
        config.setSortable(true);
        config.setWidth(120);
        config.setDataIndex(OBSERVABLE_TYPE);
        return config;
    }

    private static final ColumnConfig createMeasurementTimestampColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getExternalDataMeasurementTimestampLabel());
        config.setSortable(true);
        config.setWidth(140);
        config.setDataIndex(TIMESTAMP);
        config.setRenderer(RegistrationDateRenderer.REGISTRATION_DATE_RENDERER);
        return config;
    }

    private static final ColumnConfig createParentDatasetColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getExternalDataParentDatasetLabel());
        config.setSortable(true);
        config.setWidth(110);
        config.setDataIndex(PARENT_DATASET);
        return config;
    }

    private static final ColumnConfig createDataProducerColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getExternalDataProducerLabel());
        config.setSortable(true);
        config.setWidth(110);
        config.setDataIndex(DATA_PRODUCER);
        return config;
    }

    private static final Store createStore(ExternalData[] externalDatas, IMessageResources messageResources) {
        SimpleStore store = new SimpleStore(-1, ExternalDataDialog.createFieldDefs(), ExternalDataDialog.createData(externalDatas, messageResources));
        return store;
    }

    private static FieldDef[] createFieldDefs() {
        ArrayList<Object> fieldDefs = new ArrayList<Object>();
        fieldDefs.add(new StringFieldDef(CODE));
        fieldDefs.add(new StringFieldDef(PROCEDURE_TYPE));
        fieldDefs.add(new StringFieldDef(IS_COMPLETE));
        fieldDefs.add(new StringFieldDef(OBSERVABLE_TYPE));
        fieldDefs.add(new StringFieldDef(FILE_FORMAT_TYPE));
        fieldDefs.add(new DateFieldDef("registrationDate"));
        fieldDefs.add(new StringFieldDef(LOCATION));
        fieldDefs.add(new StringFieldDef(LOCATOR_TYPE));
        fieldDefs.add(new DateFieldDef(TIMESTAMP));
        fieldDefs.add(new StringFieldDef(PARENT_DATASET));
        fieldDefs.add(new StringFieldDef(DATA_PRODUCER));
        return fieldDefs.toArray(new FieldDef[fieldDefs.size()]);
    }

    private static final Object[][] createData(ExternalData[] externalDatas, IMessageResources messageResources) {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        int i = 0;
        while (i < externalDatas.length) {
            ExternalData externalData = externalDatas[i];
            Object[] objects = new Object[]{externalData.getCode(), externalData.getProcedure().getProcedureType().getCode(), externalData.getComplete(), externalData.getObservableType().getCode(), externalData.getFileFormatType().getCode(), externalData.getRegistrationDate(), externalData.getLocation(), externalData.getLocatorType().getCode(), externalData.getProductionDate(), externalData.getParentDataSetCode(), externalData.getDataProducerCode()};
            data.add(objects);
            ++i;
        }
        return (Object[][])data.toArray((T[])new Object[0][]);
    }
}

