/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.Constants;
import ch.systemsx.cisd.lims.webclient.client.application.FilePropertyDialog;
import ch.systemsx.cisd.lims.webclient.client.application.FilePropertyGridModel;
import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import ch.systemsx.cisd.lims.webclient.client.application.ModelBasedGrid;
import ch.systemsx.cisd.lims.webclient.client.application.utils.WindowUtils;
import ch.systemsx.cisd.lims.webclient.client.dto.ExperimentIdentifier;
import ch.systemsx.cisd.lims.webclient.client.dto.FileProperty;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.data.Record;
import com.gwtext.client.widgets.grid.Grid;
import com.gwtext.client.widgets.grid.event.GridCellListener;
import com.gwtext.client.widgets.grid.event.GridCellListenerAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class FilePropertyGrid
extends ModelBasedGrid {
    private final FileProperty[] filteredFileProperties;
    private final FileProperty[] fileProperties;
    private final IMessageResources messageResources;
    private final ExperimentIdentifier identifier;

    FilePropertyGrid(IMessageResources messageResources, ExperimentIdentifier identifier, FileProperty[] fileProperties, String height) {
        super(messageResources, FilePropertyGrid.filterFileProperties(fileProperties), new FilePropertyGridModel(messageResources), height);
        this.identifier = identifier;
        this.filteredFileProperties = (FileProperty[])this.data;
        this.fileProperties = fileProperties;
        this.messageResources = messageResources;
        this.addGridCellListener((GridCellListener)new FilePropertyCellListener());
    }

    private static final FileProperty[] filterFileProperties(FileProperty[] fileProperties) {
        assert (fileProperties.length > 0);
        ArrayList<FileProperty> returned = new ArrayList<FileProperty>();
        Arrays.sort(fileProperties);
        FileProperty previous = null;
        int i = 0;
        while (i < fileProperties.length) {
            FileProperty fileProperty = fileProperties[i];
            if (!fileProperty.equals(previous)) {
                returned.add(fileProperty);
            }
            previous = fileProperty;
            ++i;
        }
        return returned.toArray(FileProperty.EMPTY_ARRAY);
    }

    static final String createURL(int version, String fileName, ExperimentIdentifier identifier) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Constants.EXPERIMENT_FILE_PROPERTY_DOWNLOAD_SERVLET_NAME).append("?").append("version").append("=").append(version).append("&").append("fileName").append("=").append(fileName).append("&").append("project").append("=").append(identifier.getProjectCode()).append("&").append("experiment").append("=").append(identifier.getExperimentCode());
        return buffer.toString();
    }

    private final class FilePropertyCellListener
    extends GridCellListenerAdapter {
        private FilePropertyCellListener() {
        }

        private final String createTitle(List list) {
            return String.valueOf(FilePropertyGrid.this.identifier.getExperimentCode()) + " > " + FilePropertyGrid.this.messageResources.getExperimentPanelPropertiesTitle() + " > " + ((FileProperty)list.get(0)).getFileName();
        }

        private final List getOldFileProperties(FileProperty fileProperty) {
            ArrayList<FileProperty> list = new ArrayList<FileProperty>();
            int i = 0;
            while (i < FilePropertyGrid.this.fileProperties.length) {
                FileProperty property = FilePropertyGrid.this.fileProperties[i];
                if (property.equals(fileProperty)) {
                    list.add(property);
                }
                ++i;
            }
            Collections.sort(list);
            list.remove(0);
            return list;
        }

        private final FileProperty getFileProperty(String fileName) {
            int i = 0;
            while (i < FilePropertyGrid.this.filteredFileProperties.length) {
                FileProperty fileProperty = FilePropertyGrid.this.filteredFileProperties[i];
                if (fileProperty.getFileName().equals(fileName)) {
                    return fileProperty;
                }
                ++i;
            }
            return null;
        }

        public final void onCellClick(Grid grid, int rowIndex, int colIndex, EventObject e) {
            FileProperty fileProperty;
            String dataIndex = grid.getColumnModel().getDataIndex(colIndex);
            Record record = grid.getStore().getAt(rowIndex);
            if ((dataIndex.equals("fileName") || dataIndex.equals("oldVersion")) && (fileProperty = this.getFileProperty(record.getAsString("fileName"))) != null) {
                if (dataIndex.equals("fileName")) {
                    String url = FilePropertyGrid.createURL(fileProperty.getVersion(), fileProperty.getFileName(), FilePropertyGrid.this.identifier);
                    WindowUtils.openNewDependentWindow(url);
                } else {
                    List list = this.getOldFileProperties(fileProperty);
                    if (list.size() > 0) {
                        FilePropertyDialog dialog = new FilePropertyDialog(this.createTitle(list), FilePropertyGrid.this.identifier, FilePropertyGrid.this.messageResources, list);
                        dialog.show(FilePropertyGrid.this.getElement());
                    }
                }
            }
        }
    }
}

