/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.ColumnConfigs;
import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import ch.systemsx.cisd.lims.webclient.client.application.model.AbstractDataGridModel;
import ch.systemsx.cisd.lims.webclient.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.lims.webclient.client.application.utils.PersonUtils;
import ch.systemsx.cisd.lims.webclient.client.dto.FileProperty;
import com.gwtext.client.data.DateFieldDef;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.grid.ColumnConfig;
import java.util.ArrayList;
import java.util.List;

final class FilePropertyGridModel
extends AbstractDataGridModel {
    static final String OLD_VERSION = "oldVersion";
    static final String FILE_NAME = "fileName";

    FilePropertyGridModel(IMessageResources messageResources) {
        super(messageResources);
    }

    private static final ColumnConfig createOldVersionColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getFilePropertyOldVersionLabel());
        config.setSortable(false);
        config.setWidth(140);
        config.setDataIndex(OLD_VERSION);
        config.setRenderer(LinkRenderer.LINK_RENDERER);
        return config;
    }

    private static final ColumnConfig createFileNameColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getFilePropertyFileNameLabel());
        config.setSortable(true);
        config.setWidth(160);
        config.setDataIndex(FILE_NAME);
        config.setRenderer(LinkRenderer.LINK_RENDERER);
        return config;
    }

    private static final String toString(int version, IMessageResources messageResources) {
        if (version < 2) {
            return null;
        }
        return messageResources.getFilePropertyOldVersionCount(version - 1);
    }

    public final List getColumnConfigs() {
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
        configs.add(FilePropertyGridModel.createFileNameColumnConfig(this.messageResources));
        configs.add(ColumnConfigs.createRegistratorColumnConfig(this.messageResources));
        configs.add(ColumnConfigs.createRegistrationDateColumnConfig(this.messageResources));
        configs.add(FilePropertyGridModel.createOldVersionColumnConfig(this.messageResources));
        return configs;
    }

    public final List getData(Object[] data) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        int i = 0;
        while (i < data.length) {
            FileProperty fileProperty = (FileProperty)data[i];
            String registrator = PersonUtils.toString(fileProperty.getRegistrator());
            Object[] objects = new Object[]{fileProperty.getFileName(), registrator, fileProperty.getRegistrationDate(), FilePropertyGridModel.toString(fileProperty.getVersion(), this.messageResources)};
            list.add(objects);
            ++i;
        }
        return list;
    }

    public final List getFieldDefs() {
        ArrayList<Object> fieldDefs = new ArrayList<Object>();
        fieldDefs.add(new StringFieldDef(FILE_NAME));
        fieldDefs.add(new StringFieldDef("registrator"));
        fieldDefs.add(new DateFieldDef("registrationDate"));
        fieldDefs.add(new StringFieldDef(OLD_VERSION));
        return fieldDefs;
    }
}

