/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.context.ViewContext;
import ch.systemsx.cisd.lims.webclient.client.application.ui.LoginWidget;
import ch.systemsx.cisd.lims.webclient.client.application.utils.ImageUtils;
import ch.systemsx.cisd.lims.webclient.client.dto.User;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

class LoginPage
extends VerticalPanel {
    private static final int CELL_SPACING = 20;
    private final ViewContext viewContext;

    LoginPage(ViewContext viewContext) {
        this.setSpacing(20);
        this.setWidth("100%");
        this.setHorizontalAlignment(VerticalPanel.ALIGN_CENTER);
        this.viewContext = viewContext;
        LoginWidget loginWidget = this.createLoginWidget();
        DockPanel loginPanel = new DockPanel();
        loginPanel.add((Widget)loginWidget, DockPanel.CENTER);
        Image cisdLogo = this.createImage();
        HTML welcomePanel = this.createWelcomePanel();
        CellPanel northPanel = LoginPage.createNorthPanel();
        northPanel.add((Widget)cisdLogo);
        northPanel.add((Widget)welcomePanel);
        this.add((Widget)northPanel);
        this.add((Widget)loginPanel);
    }

    private static final CellPanel createNorthPanel() {
        HorizontalPanel horizontalPanel = new HorizontalPanel();
        horizontalPanel.setSpacing(20);
        return horizontalPanel;
    }

    private final LoginWidget createLoginWidget() {
        LoginWidget loginWidget = new LoginWidget(this.viewContext){

            protected final void loginSuccessful(User user) {
                super.loginSuccessful(user);
                LoginPage.this.viewContext.getPageController().createMainPage();
            }
        };
        return loginWidget;
    }

    private final Image createImage() {
        Image image = ImageUtils.getLogoImage();
        image.setTitle(this.viewContext.getMessageResources().getCISDLogoTitle());
        return image;
    }

    private final HTML createWelcomePanel() {
        HTML html = new HTML(this.viewContext.getMessageResources().getLoginWelcomeText());
        html.setStyleName("lims-font-huge");
        return html;
    }
}

