/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import ch.systemsx.cisd.lims.webclient.client.application.ui.AbstractLayoutDialog;
import ch.systemsx.cisd.lims.webclient.client.application.utils.ImageUtils;
import ch.systemsx.cisd.lims.webclient.client.dto.Material;
import ch.systemsx.cisd.lims.webclient.client.dto.PlateWells;
import ch.systemsx.cisd.lims.webclient.client.dto.SampleComponent;
import ch.systemsx.cisd.lims.webclient.client.dto.SimpleEntityProperty;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.layout.ContentPanel;

public final class PlateVisualisationDialog
extends AbstractLayoutDialog {
    private final PlateWells plate;

    public PlateVisualisationDialog(PlateWells plate, String title, IMessageResources messageResources) {
        super(messageResources, title, PlateVisualisationDialog.calculateWidgetWidth(plate.getColsNum()), PlateVisualisationDialog.calculateWidgetHeight(plate.getRowsNum()));
        this.plate = plate;
        this.addContentPanel();
    }

    private static int calculateWidgetWidth(int numPlateCols) {
        return numPlateCols * 18 + 80;
    }

    private static int calculateWidgetHeight(int numPlateRows) {
        return numPlateRows * 18 + 120;
    }

    protected final Widget createContentWidget() {
        Grid grid = new Grid(this.plate.getRowsNum() + 1, this.plate.getColsNum() + 1);
        SampleComponent[][] matrix = this.setWellsContent(grid);
        this.setWellNames(grid, matrix);
        ContentPanel panel = new ContentPanel();
        panel.add((Widget)grid);
        panel.add((Widget)new Label(this.messageResources.getPlateLayoutDescription()));
        return panel;
    }

    private SampleComponent[][] setWellsContent(Grid grid) {
        SampleComponent[][] matrix = this.plate.getMatrix();
        int rowIx = 0;
        while (rowIx < this.plate.getRowsNum()) {
            int colIx = 0;
            while (colIx < this.plate.getColsNum()) {
                SampleComponent well = matrix[rowIx][colIx];
                Widget wellWidget = this.createWellWidget(well);
                grid.setWidget(rowIx + 1, colIx + 1, wellWidget);
                ++colIx;
            }
            ++rowIx;
        }
        return matrix;
    }

    private void setWellNames(Grid grid, SampleComponent[][] matrix) {
        int rowIx = 0;
        while (rowIx < this.plate.getRowsNum()) {
            String rowName = PlateVisualisationDialog.figureRowName(rowIx);
            grid.setText(rowIx + 1, 0, rowName);
            ++rowIx;
        }
        int colIx = 0;
        while (colIx < this.plate.getColsNum()) {
            String colName = "" + (colIx + 1);
            Label label = new Label(colName);
            label.setHorizontalAlignment(Label.ALIGN_CENTER);
            grid.setWidget(0, colIx + 1, (Widget)label);
            ++colIx;
        }
    }

    private static final String figureRowName(int rowIx) {
        int ix = rowIx;
        String name = "";
        int maxLetterNumber = 26;
        do {
            name = String.valueOf((char)(65 + ix % maxLetterNumber)) + name;
        } while ((ix = ix / maxLetterNumber - 1) >= 0);
        return name;
    }

    private Widget createWellWidget(SampleComponent wellOrNull) {
        if (wellOrNull != null) {
            Material material = wellOrNull.getMaterialBatch().getMaterial();
            String materialTypeCode = material.getMaterialType().getCode();
            Image img = materialTypeCode.compareTo("CONTROL") == 0 ? ImageUtils.getControlWell() : ImageUtils.getMaterialWell();
            String materialDesc = this.getMaterialDescription(material);
            this.setWellDescription(img, wellOrNull, materialDesc);
            return img;
        }
        return ImageUtils.getEmptyWell();
    }

    private void setWellDescription(Image wellImg, final SampleComponent well, final String materialDesc) {
        wellImg.setTitle(materialDesc);
        wellImg.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                String wellDesc = String.valueOf(PlateVisualisationDialog.this.messageResources.getMasterPlateWellLabel()) + " " + well.getWellCoordinates().getCode();
                MessageBox.alert((String)wellDesc, (String)materialDesc);
            }
        });
    }

    private String getMaterialDescription(Material material) {
        String inhibitorDesc;
        StringBuffer sb = new StringBuffer();
        Material inhibitorOf = material.getInhibitorOf();
        if (inhibitorOf != null && (inhibitorDesc = PlateVisualisationDialog.tryFindPropertyUntypedValue(inhibitorOf.getProperties(), "USER.GENE_SYMBOL")) != null) {
            PlateVisualisationDialog.appendLine(sb, this.messageResources.getMaterialInhibitsLabel(), inhibitorDesc);
        }
        String materialTypeCode = material.getMaterialType().getCode();
        String materialCode = material.getCode();
        String materialSpec = String.valueOf(materialCode) + " (" + materialTypeCode + ")";
        PlateVisualisationDialog.appendLine(sb, this.messageResources.getMaterialLabel(), materialSpec, true);
        return sb.toString();
    }

    private static String tryFindPropertyUntypedValue(SimpleEntityProperty[] properties, String propertyName) {
        SimpleEntityProperty prop = PlateVisualisationDialog.tryFindProperty(properties, propertyName);
        if (prop != null) {
            return prop.tryGetUntypedValue();
        }
        return null;
    }

    private static SimpleEntityProperty tryFindProperty(SimpleEntityProperty[] properties, String propertyName) {
        int i = 0;
        while (i < properties.length) {
            SimpleEntityProperty prop = properties[i];
            if (prop.getCode().equals(propertyName)) {
                return prop;
            }
            ++i;
        }
        return null;
    }

    private static void appendLine(StringBuffer sb, String title, String value) {
        PlateVisualisationDialog.appendLine(sb, title, value, false);
    }

    private static void appendLine(StringBuffer sb, String title, String value, boolean isLastLine) {
        sb.append(title);
        sb.append(": ");
        sb.append(value);
        sb.append(".");
        if (!isLastLine) {
            sb.append("\n");
        }
    }
}

