/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.ILIMSServiceAsync;
import ch.systemsx.cisd.lims.webclient.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.lims.webclient.client.application.ExperimentSampleCache;
import ch.systemsx.cisd.lims.webclient.client.application.ExternalDataDialog;
import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import ch.systemsx.cisd.lims.webclient.client.application.SampleGenerationDialog;
import ch.systemsx.cisd.lims.webclient.client.application.context.ViewContext;
import ch.systemsx.cisd.lims.webclient.client.application.utils.DOMUtils;
import ch.systemsx.cisd.lims.webclient.client.application.utils.StringUtils;
import ch.systemsx.cisd.lims.webclient.client.dto.ExternalData;
import ch.systemsx.cisd.lims.webclient.client.dto.Sample;
import ch.systemsx.cisd.lims.webclient.client.dto.SampleGeneration;
import com.google.gwt.user.client.Element;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.data.Record;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.Grid;
import com.gwtext.client.widgets.grid.event.GridCellListenerAdapter;

final class ResultSamplesCellListener
extends GridCellListenerAdapter {
    private final String experimentCode;
    private final ViewContext viewContext;
    private final Element targetElement;

    ResultSamplesCellListener(Element targetElement, ViewContext viewContext, String experimentCode) {
        assert (targetElement != null);
        assert (experimentCode != null);
        this.experimentCode = experimentCode;
        this.viewContext = viewContext;
        this.targetElement = targetElement;
    }

    public final void onCellClick(Grid grid, int rowIndex, int colIndex, EventObject e) {
        ColumnModel columnModel = grid.getColumnModel();
        String dataIndex = columnModel.getDataIndex(colIndex);
        ILIMSServiceAsync limsService = this.viewContext.getLimService();
        IMessageResources messageResources = this.viewContext.getMessageResources();
        if (dataIndex.equals("generatedFrom") || dataIndex.equals("top")) {
            String sampleCode = ResultSamplesCellListener.tryGetSampleCode(grid, rowIndex, dataIndex);
            if (sampleCode != null) {
                limsService.getSampleInfo(sampleCode, new SampleInfoCallBack());
            }
        } else if (dataIndex.equals("controlLayout") || dataIndex.equals("code")) {
            String sampleCode = ResultSamplesCellListener.tryGetSampleCode(grid, rowIndex, dataIndex);
            if (sampleCode != null) {
                limsService.getSampleInfo(sampleCode, new SampleInfoCallBack());
            }
        } else if (dataIndex.equals("derivedData") || dataIndex.equals("measurementData")) {
            String dataType;
            ExternalData[] externalDatas;
            Sample sample = ResultSamplesCellListener.tryGetSample(grid, rowIndex, "code");
            if (sample == null) {
                return;
            }
            if (dataIndex.equals("measurementData")) {
                externalDatas = sample.getMeasurementData();
                dataType = messageResources.getSampleMeasurementDataLabel();
            } else {
                externalDatas = sample.getDerivedData();
                dataType = messageResources.getSampleDerivedDataLabel();
            }
            if (externalDatas.length > 0) {
                ExternalDataDialog dialog = new ExternalDataDialog(this.createTitle(dataType), externalDatas, messageResources);
                dialog.show(this.targetElement);
            }
        }
    }

    private final String createTitle(String dataType) {
        return String.valueOf(this.experimentCode) + " > " + this.viewContext.getMessageResources().getExperimentPanelPlatesTitle() + " > " + dataType;
    }

    private static final Sample tryGetSample(Grid grid, int rowIndex, String dataIndex) {
        String sampleCode = ResultSamplesCellListener.tryGetSampleCode(grid, rowIndex, dataIndex);
        return sampleCode == null ? null : ExperimentSampleCache.getSample(sampleCode);
    }

    private static String tryGetSampleCode(Grid grid, int rowIndex, String dataIndex) {
        Record record = grid.getStore().getAt(rowIndex);
        String sampleCode = record.getAsString(dataIndex);
        return StringUtils.isEmpty(sampleCode) ? null : sampleCode;
    }

    private final class SampleInfoCallBack
    extends AbstractAsyncCallback {
        SampleInfoCallBack() {
            super(ResultSamplesCellListener.this.viewContext);
        }

        private String createTitle(SampleGeneration sampleGeneration) {
            return String.valueOf(ResultSamplesCellListener.this.experimentCode) + " > " + ResultSamplesCellListener.this.viewContext.getMessageResources().getExperimentPanelPlatesTitle() + " > " + this.getGeneratorTitle(sampleGeneration.getGenerator());
        }

        private final String getGeneratorTitle(Sample generator) {
            String title = generator.getCode();
            if (generator.getInvalidation() != null) {
                return DOMUtils.createDelElement(title);
            }
            return title;
        }

        public final void onSuccess(Object result) {
            SampleGeneration generation = (SampleGeneration)result;
            SampleGenerationDialog dialog = new SampleGenerationDialog(this.createTitle(generation), generation, ResultSamplesCellListener.this.viewContext);
            dialog.show(ResultSamplesCellListener.this.targetElement);
        }
    }
}

