/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.PropertyValueRenderers;
import ch.systemsx.cisd.lims.webclient.client.application.ShowLayoutClickListener;
import ch.systemsx.cisd.lims.webclient.client.application.context.ViewContext;
import ch.systemsx.cisd.lims.webclient.client.application.ui.AbstractLayoutDialog;
import ch.systemsx.cisd.lims.webclient.client.application.ui.PropertyGrid;
import ch.systemsx.cisd.lims.webclient.client.application.utils.OrderedMap;
import ch.systemsx.cisd.lims.webclient.client.dto.Invalidation;
import ch.systemsx.cisd.lims.webclient.client.dto.Sample;
import ch.systemsx.cisd.lims.webclient.client.dto.SampleGeneration;
import ch.systemsx.cisd.lims.webclient.client.dto.SampleType;
import ch.systemsx.cisd.lims.webclient.client.dto.SimpleEntityProperty;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

final class SampleGenerationDialog
extends AbstractLayoutDialog {
    private final SampleGeneration sampleGeneration;
    private final ViewContext viewContext;

    public SampleGenerationDialog(String title, SampleGeneration sampleGeneration, ViewContext viewContext) {
        super(viewContext.getMessageResources(), title);
        this.sampleGeneration = sampleGeneration;
        this.viewContext = viewContext;
        this.addContentPanel();
    }

    private final String getGeneratedLabel(Sample sample) {
        SampleType sampleType = sample.getSampleType();
        return sampleType.getDescription();
    }

    protected final Widget createContentWidget() {
        String key;
        Object[] generated;
        OrderedMap properties = new OrderedMap(false);
        Sample sample = this.sampleGeneration.getGenerator();
        properties.put(this.messageResources.getRegistratorLabel(), sample.getRegistrator());
        properties.put(this.messageResources.getRegistrationLabel(), sample.getRegistrationDate());
        if (sample.getTop() != null) {
            properties.put(this.messageResources.getSampleTopLabel(), sample.getTop());
        }
        Invalidation invalidation = sample.getInvalidation();
        SampleGenerationDialog.putPropertiesDescription(properties, this.sampleGeneration);
        if (invalidation != null) {
            properties.put(this.messageResources.getSampleInvalidationLabel(), invalidation);
        }
        if ((generated = this.sampleGeneration.getGenerated()).length > 0) {
            Arrays.sort(generated);
            properties.put(this.getGeneratedLabel((Sample)generated[0]), generated);
        }
        String controlLayoutCode = sample.getControlLayoutCode();
        HashMap<String, ShowLayoutClickListener> listeners = new HashMap<String, ShowLayoutClickListener>();
        if (controlLayoutCode != null) {
            HTML controlLayoutButton = new HTML(controlLayoutCode);
            controlLayoutButton.setStyleName("lims-a");
            key = this.messageResources.getVisualizationControlLayoutLabel();
            properties.put(key, controlLayoutButton);
            listeners.put(key, new ShowLayoutClickListener(controlLayoutCode, (Widget)this, this.viewContext));
        }
        HTML plateVisualizationButton = new HTML(sample.getCode());
        if (sample.getInvalidation() == null) {
            plateVisualizationButton.setStyleName("lims-a");
        } else {
            plateVisualizationButton.setStyleName("lims-a-strike");
        }
        key = sample.getSampleType().getCode().equals("CONTROL_LAYOUT") ? this.messageResources.getVisualizationControlLayoutLabel() : this.messageResources.getVisualizationPlateLabel();
        properties.put(key, plateVisualizationButton);
        listeners.put(key, new ShowLayoutClickListener(sample.getCode(), (Widget)this, this.viewContext));
        PropertyGrid propertyGrid = this.createPropertyGrid(properties);
        for (Map.Entry entry : listeners.entrySet()) {
            propertyGrid.addGridCellListener((String)entry.getKey(), (PropertyGrid.GridCellListener)entry.getValue());
        }
        return propertyGrid;
    }

    private static void putPropertiesDescription(OrderedMap properties, SampleGeneration sampleGeneration) {
        Sample sample = sampleGeneration.getGenerator();
        SimpleEntityProperty[] entityProperties = sample.getProperties();
        int i = 0;
        while (i < entityProperties.length) {
            if (entityProperties[i] != null) {
                properties.put(entityProperties[i].getUserLabel(), entityProperties[i].tryGetUntypedValue());
            }
            ++i;
        }
    }

    private final PropertyGrid createPropertyGrid(OrderedMap properties) {
        PropertyGrid propertyGrid = new PropertyGrid(this.messageResources, properties.size());
        propertyGrid.registerPropertyValueRenderer("ch.systemsx.cisd.lims.webclient.client.dto.Person", new PropertyValueRenderers.PersonPropertyValueRenderer(this.messageResources));
        propertyGrid.registerPropertyValueRenderer("ch.systemsx.cisd.lims.webclient.client.dto.Sample", new PropertyValueRenderers.SamplePropertyValueRenderer(this.messageResources));
        propertyGrid.registerPropertyValueRenderer("ch.systemsx.cisd.lims.webclient.client.dto.Invalidation", new PropertyValueRenderers.InvalidationPropertyValueRenderer(this.messageResources));
        propertyGrid.setProperties(properties);
        return propertyGrid;
    }
}

