/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application.model;

import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import ch.systemsx.cisd.lims.webclient.client.application.model.AbstractDataGridModel;
import ch.systemsx.cisd.lims.webclient.client.dto.ProcessingInstruction;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.grid.ColumnConfig;
import java.util.ArrayList;
import java.util.List;

public class ProcessingInstructionGridModel
extends AbstractDataGridModel {
    private static final String DESCRIPTION = "description";
    private static final String PATH = "path";
    private static final String PROCEDURE = "procedure";

    public ProcessingInstructionGridModel(IMessageResources messageResources) {
        super(messageResources);
    }

    public List getFieldDefs() {
        ArrayList<StringFieldDef> defs = new ArrayList<StringFieldDef>();
        defs.add(new StringFieldDef(PROCEDURE));
        defs.add(new StringFieldDef(PATH));
        defs.add(new StringFieldDef(DESCRIPTION));
        return defs;
    }

    public List getColumnConfigs() {
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
        configs.add(this.createColumnConfig(PROCEDURE, this.messageResources.getProcessingInstructionProcedureTypeLabel(), 150));
        configs.add(this.createColumnConfig(PATH, this.messageResources.getProcessingInstructionPathLabel(), 150));
        configs.add(this.createColumnConfig(DESCRIPTION, this.messageResources.getProcessingInstructionDescriptionLabel(), 250));
        return configs;
    }

    public List getData(Object[] data) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        int i = 0;
        while (i < data.length) {
            ProcessingInstruction instruction = (ProcessingInstruction)data[i];
            String procedureTypeCode = instruction.getProcedureTypeCode();
            String processingPath = instruction.getPath();
            String processingDescription = instruction.getDescription();
            list.add(new Object[]{procedureTypeCode, processingPath, processingDescription});
            ++i;
        }
        return list;
    }
}

