/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application.model;

import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import ch.systemsx.cisd.lims.webclient.client.application.model.InputSampleGridModel;
import ch.systemsx.cisd.lims.webclient.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.lims.webclient.client.application.renderer.SampleWithInvalidationAndLinkRenderer;
import ch.systemsx.cisd.lims.webclient.client.application.utils.PersonUtils;
import ch.systemsx.cisd.lims.webclient.client.dto.ExternalData;
import ch.systemsx.cisd.lims.webclient.client.dto.Procedure;
import ch.systemsx.cisd.lims.webclient.client.dto.ProcedureType;
import ch.systemsx.cisd.lims.webclient.client.dto.Sample;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.widgets.grid.ColumnConfig;
import com.gwtext.client.widgets.grid.Renderer;
import java.util.ArrayList;
import java.util.List;

public final class ResultSampleGridModel
extends InputSampleGridModel {
    private static final int INSERTION_INDEX = 2;
    public static final String CONTROL_LAYOUT = "controlLayout";
    public static final String DERIVED_DATA = "derivedData";
    public static final String MEASUREMENT_DATA = "measurementData";
    public static final String TOP = "top";
    public static final String GENERATED_FROM = "generatedFrom";
    private final ProcedureType procedureType;

    public ResultSampleGridModel(IMessageResources messageResources, ProcedureType procedureType) {
        super(messageResources);
        this.procedureType = procedureType;
    }

    private static final ColumnConfig createControlLayoutColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getControlLayoutLabel());
        config.setSortable(true);
        config.setWidth(140);
        config.setDataIndex(CONTROL_LAYOUT);
        config.setRenderer(LinkRenderer.LINK_RENDERER);
        return config;
    }

    private static final ColumnConfig createMeasurementDataColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getSampleMeasurementDataLabel());
        config.setSortable(false);
        config.setWidth(140);
        config.setDataIndex(MEASUREMENT_DATA);
        config.setRenderer(LinkRenderer.LINK_RENDERER);
        return config;
    }

    private static final ColumnConfig createDerivedDataColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getSampleDerivedDataLabel());
        config.setSortable(false);
        config.setWidth(140);
        config.setDataIndex(DERIVED_DATA);
        config.setRenderer(LinkRenderer.LINK_RENDERER);
        return config;
    }

    private static final ColumnConfig createGeneratedFromColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getSampleGeneratedFromLabel());
        config.setSortable(true);
        config.setWidth(120);
        config.setDataIndex(GENERATED_FROM);
        config.setRenderer((Renderer)new SampleWithInvalidationAndLinkRenderer(messageResources));
        return config;
    }

    private static final ColumnConfig createTopColumnConfig(IMessageResources messageResources) {
        ColumnConfig config = new ColumnConfig();
        config.setHeader(messageResources.getSampleTopLabel());
        config.setSortable(true);
        config.setWidth(100);
        config.setDataIndex(TOP);
        config.setRenderer((Renderer)new SampleWithInvalidationAndLinkRenderer(messageResources));
        return config;
    }

    private static final String convertToString(Sample sample) {
        if (sample == null) {
            return null;
        }
        return sample.getCode();
    }

    private final String convertToString(List externalDatas) {
        int size = externalDatas.size();
        if (size < 1) {
            return null;
        }
        return this.messageResources.getSampleExternalDataCount(size);
    }

    private final String filterExternalData(ExternalData[] externalData) {
        ArrayList<ExternalData> filteredData = new ArrayList<ExternalData>();
        int i = 0;
        while (i < externalData.length) {
            block6: {
                ExternalData data;
                block5: {
                    data = externalData[i];
                    Procedure procedure = data.getProcedure();
                    if (procedure == null) break block5;
                    ProcedureType type = procedure.getProcedureType();
                    assert (type != null) : "If procedure exists, procedure type can not be null.";
                    if (!type.equals(this.procedureType)) break block6;
                }
                filteredData.add(data);
            }
            ++i;
        }
        return this.convertToString(filteredData);
    }

    public final List getData(Object[] data) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        int i = 0;
        while (i < data.length) {
            Sample sample = (Sample)data[i];
            String registrator = PersonUtils.toString(sample.getRegistrator());
            String externalData = this.isDataAcquisitionProcedure() ? this.filterExternalData(sample.getMeasurementData()) : this.filterExternalData(sample.getDerivedData());
            Object[] objects = new Object[]{ResultSampleGridModel.convertToString(sample), sample.getSampleType().getCode(), sample.getControlLayoutCode(), ResultSampleGridModel.convertToString(sample.getGeneratedFrom()), ResultSampleGridModel.convertToString(sample.getTop()), registrator, sample.getRegistrationDate(), externalData};
            list.add(objects);
            ++i;
        }
        return list;
    }

    private boolean isDataAcquisitionProcedure() {
        return this.procedureType.getCode().equals("DATA_ACQUISITION");
    }

    public final List getFieldDefs() {
        List list = super.getFieldDefs();
        list.add(2, new StringFieldDef(TOP));
        list.add(2, new StringFieldDef(GENERATED_FROM));
        list.add(2, new StringFieldDef(CONTROL_LAYOUT));
        if (this.isDataAcquisitionProcedure()) {
            list.add(new StringFieldDef(MEASUREMENT_DATA));
        } else {
            list.add(new StringFieldDef(DERIVED_DATA));
        }
        return list;
    }

    public final List getColumnConfigs() {
        List list = super.getColumnConfigs();
        list.add(2, ResultSampleGridModel.createTopColumnConfig(this.messageResources));
        list.add(2, ResultSampleGridModel.createGeneratedFromColumnConfig(this.messageResources));
        list.add(2, ResultSampleGridModel.createControlLayoutColumnConfig(this.messageResources));
        if (this.isDataAcquisitionProcedure()) {
            list.add(ResultSampleGridModel.createMeasurementDataColumnConfig(this.messageResources));
        } else {
            list.add(ResultSampleGridModel.createDerivedDataColumnConfig(this.messageResources));
        }
        return list;
    }

    protected final ColumnConfig createCodeColumnConfig() {
        ColumnConfig columnConfig = this.createSortableColumnConfig("code", this.messageResources.getSampleCodeLabel(), 100);
        columnConfig.setRenderer((Renderer)new SampleWithInvalidationAndLinkRenderer(this.messageResources));
        return columnConfig;
    }
}

