/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.server;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.lims.webclient.client.ILIMSService;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.log4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

abstract class AbstractLIMSServiceServlet
extends HttpServlet {
    protected static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, AbstractLIMSServiceServlet.class);
    protected static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, AbstractLIMSServiceServlet.class);
    protected ILIMSService limsService;

    AbstractLIMSServiceServlet(ILIMSService limsService) {
        this.limsService = limsService;
    }

    public AbstractLIMSServiceServlet() {
    }

    private final void initLIMSService() {
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        this.limsService = (ILIMSService)context.getBean("web-openbis-service");
    }

    public final void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        LogInitializer.init();
        try {
            this.initLIMSService();
        }
        catch (Exception ex) {
            notificationLog.fatal("Failure during '" + servletConfig.getServletName() + "' servlet initialization.", ex);
            throw new ServletException((Throwable)ex);
        }
    }
}

