/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.server;

import ch.systemsx.cisd.lims.webclient.client.UserFailureException;
import ch.systemsx.cisd.lims.webclient.client.dto.ExperimentFileAttachment;
import ch.systemsx.cisd.lims.webclient.client.dto.ExperimentIdentifier;
import ch.systemsx.cisd.lims.webclient.server.AbstractLIMSServiceServlet;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public final class ExperimentFilePropertyDownloadServlet
extends AbstractLIMSServiceServlet {
    private static final long serialVersionUID = 1L;

    private static final String createFilePropertyDescription(String project, String experiment, String fileName, int version) {
        StringBuilder builder = new StringBuilder();
        builder.append("project=").append(project).append(",");
        builder.append("experiment=").append(experiment).append(",");
        builder.append("fileName=").append(fileName).append(",");
        builder.append("version=").append(version);
        return builder.toString();
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int version = Integer.parseInt(request.getParameter("version"));
        String fileName = request.getParameter("fileName");
        String project = request.getParameter("project");
        String experiment = request.getParameter("experiment");
        try {
            if (StringUtils.isNotBlank(fileName) && StringUtils.isNotBlank(project) && StringUtils.isNotBlank(experiment)) {
                ExperimentFileAttachment experimentFileProperty = this.limsService.getExperimentFileAttachment(new ExperimentIdentifier(project, experiment), fileName, version);
                byte[] value = experimentFileProperty.getValue();
                response.setContentLength(value.length);
                response.setHeader("Content-Disposition", "inline; filename=" + experimentFileProperty.getFileProperty().getFileName());
                ServletOutputStream outputStream = response.getOutputStream();
                outputStream.write(value);
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (UserFailureException ex) {
            operationLog.error("Getting experiment file property [" + ExperimentFilePropertyDownloadServlet.createFilePropertyDescription(project, experiment, fileName, version) + "] failed.", (Throwable)((Object)ex));
            throw new ServletException((Throwable)((Object)ex));
        }
    }
}

