/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.server;

import ch.systemsx.cisd.common.collections.CollectionStyle;
import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.lims.base.ProcedureTypeCode;
import ch.systemsx.cisd.lims.webclient.client.ILIMSService;
import ch.systemsx.cisd.lims.webclient.client.UserFailureException;
import ch.systemsx.cisd.lims.webclient.client.dto.Experiment;
import ch.systemsx.cisd.lims.webclient.client.dto.ExperimentIdentifier;
import ch.systemsx.cisd.lims.webclient.client.dto.Material;
import ch.systemsx.cisd.lims.webclient.client.dto.MaterialBatch;
import ch.systemsx.cisd.lims.webclient.client.dto.PlateWells;
import ch.systemsx.cisd.lims.webclient.client.dto.Procedure;
import ch.systemsx.cisd.lims.webclient.client.dto.Sample;
import ch.systemsx.cisd.lims.webclient.client.dto.SampleComponent;
import ch.systemsx.cisd.lims.webclient.server.AbstractLIMSServiceServlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExperimentMappingFileDownloadServlet
extends AbstractLIMSServiceServlet {
    static final String HEADER_VALUE_FORMAT = "inline; filename=%s";
    static final String HEADER_KEY = "Content-Disposition";
    static final String[] PARAMETERS = new String[]{"experiment", "project"};
    static final String BLANK_PARAMETERS = "At least one of request parameters %s is blank (%s).";
    private static final String COMMENT_STRING = "# ";
    private static final String EXPERIMENT_CODE_FORMAT = "Experiment Code: %s";
    private static final String INCONSISTENT_SAMPLES_FORMAT = "INCONSISTENT SAMPLES: %s";
    private static final String[] COLUMN_NAMES = new String[]{"SAMPLE_CODE", "ROW_NO", "COL_NO", "OLIGO_CODE"};
    private static final char TAB_CHAR = '\t';
    private static final long serialVersionUID = 1L;

    ExperimentMappingFileDownloadServlet(ILIMSService limService) {
        super(limService);
    }

    public ExperimentMappingFileDownloadServlet() {
    }

    static final String getExperimentDescription(String experimentCode, String projectCode) {
        return "[project=" + projectCode + ",experiment=" + experimentCode + "]";
    }

    static final String getFileName(String projectCode, String experimentCode) {
        return String.valueOf(projectCode) + "_" + experimentCode + ".txt";
    }

    static final Procedure tryGetProcedure(Experiment experiment) {
        Procedure[] procedureArray = experiment.getProcedures();
        int n = procedureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Procedure procedure = procedureArray[n2];
            ProcedureTypeCode procedureType = ProcedureTypeCode.getProcedureTypeCode(procedure.getProcedureType().getCode());
            if (procedureType.equals((Object)ProcedureTypeCode.DATA_ACQUISITION)) {
                return procedure;
            }
            ++n2;
        }
        return null;
    }

    static final String getHeaderLine(String headerLine) {
        return COMMENT_STRING + headerLine;
    }

    static final List<String> getHeaderLines(String experimentCode, List<Sample> inconsistent) {
        ArrayList<String> headerLines = new ArrayList<String>();
        headerLines.add(ExperimentMappingFileDownloadServlet.getHeaderLine(String.format(EXPERIMENT_CODE_FORMAT, experimentCode)));
        if (inconsistent.size() > 0) {
            headerLines.add(ExperimentMappingFileDownloadServlet.getHeaderLine(String.format(INCONSISTENT_SAMPLES_FORMAT, CollectionUtils.abbreviate(inconsistent, -1, CollectionStyle.SINGLE_QUOTE_BOUNDARY))));
        }
        headerLines.add(ExperimentMappingFileDownloadServlet.getHeaderLine(StringUtils.join((Object[])COLUMN_NAMES, ' ')));
        return headerLines;
    }

    static final String createLine(String sampleCode, int row, int column, String materialCode) {
        assert (StringUtils.isNotBlank(sampleCode)) : "Given sample code is not blank.";
        assert (StringUtils.isNotBlank(materialCode)) : "Given material code is not blank.";
        StringBuilder builder = new StringBuilder();
        builder.append(sampleCode);
        builder.append('\t');
        builder.append(row + 1);
        builder.append('\t');
        builder.append(column + 1);
        builder.append('\t');
        builder.append(materialCode);
        return builder.toString();
    }

    private final PlateWells getPlateWells(Sample sample) throws UserFailureException {
        assert (sample != null) : "Given sample should not be null.";
        assert (sample.getCode() != null) : "Given sample must have a code.";
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        PlateWells plateWells = this.limsService.getPlateWells(sample.getCode(), false);
        stopWatch.stop();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("Getting plate wells for sample '%s' took %s.", sample.getCode(), stopWatch));
        }
        return plateWells;
    }

    private final Map<Sample, PlateWells> createSamplePlateWellsMap(Sample[] samples) throws UserFailureException {
        TreeMap<Sample, PlateWells> map = new TreeMap<Sample, PlateWells>();
        Sample[] sampleArray = samples;
        int n = samples.length;
        int n2 = 0;
        while (n2 < n) {
            Sample sample = sampleArray[n2];
            map.put(sample, this.getPlateWells(sample));
            ++n2;
        }
        return map;
    }

    private boolean writeSamplePlateWellsEntry(StringBuilder builder, String sampleCode, PlateWells sampleWells) {
        SampleComponent[][] sampleComponents = sampleWells.getMatrix();
        int row = 0;
        while (row < sampleComponents.length) {
            SampleComponent[] components = sampleComponents[row];
            int column = 0;
            while (column < components.length) {
                SampleComponent sampleComponent = components[column];
                String materialCode = null;
                if (sampleComponent != null) {
                    MaterialBatch materialBatch = sampleComponent.getMaterialBatch();
                    assert (materialBatch != null) : "Material batch can not be null.";
                    Material material = materialBatch.getMaterial();
                    assert (material != null) : "Material can not be null.";
                    materialCode = material.getCode();
                }
                if (materialCode != null) {
                    builder.append(ExperimentMappingFileDownloadServlet.createLine(sampleCode, row, column, materialCode)).append('\n');
                }
                ++column;
            }
            ++row;
        }
        return !sampleWells.isConsistent();
    }

    private final String createMappingFile(Experiment experiment) throws UserFailureException {
        assert (experiment.getCode() != null) : "Experiment code can not be null.";
        Procedure procedure = ExperimentMappingFileDownloadServlet.tryGetProcedure(experiment);
        assert (procedure != null) : "No reason to call this servlet if we have no procedure of type 'DATA_ACQUISITION'.";
        Sample[] resultSamples = procedure.getResultSamples();
        assert (resultSamples.length > 0) : "No reason to call this servlet if we have no result samples.";
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("Samples '%s' of experiment '%s' are being written out to the mapping file.", Arrays.asList(resultSamples), experiment.getCode()));
        }
        Map<Sample, PlateWells> samplePlateWells = this.createSamplePlateWellsMap(resultSamples);
        StringBuilder mappingFile = new StringBuilder();
        ArrayList<Sample> inconsistent = new ArrayList<Sample>();
        for (Map.Entry<Sample, PlateWells> entry : samplePlateWells.entrySet()) {
            PlateWells sampleWells = entry.getValue();
            Sample sample = entry.getKey();
            if (!this.writeSamplePlateWellsEntry(mappingFile, sample.getCode(), sampleWells)) continue;
            inconsistent.add(sample);
        }
        StringBuilder header = new StringBuilder();
        for (String line : ExperimentMappingFileDownloadServlet.getHeaderLines(experiment.getCode(), inconsistent)) {
            header.append(line).append('\n');
        }
        mappingFile.insert(0, header);
        return mappingFile.toString();
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String experimentCode = request.getParameter("experiment");
        String projectCode = request.getParameter("project");
        try {
            if (StringUtils.isNotBlank(experimentCode) && StringUtils.isNotBlank(projectCode)) {
                Experiment experiment = this.limsService.getExperimentInfo(new ExperimentIdentifier(projectCode, experimentCode));
                String fileName = ExperimentMappingFileDownloadServlet.getFileName(projectCode, experimentCode);
                StopWatch stopWatch = new StopWatch();
                stopWatch.start();
                String mappingFile = this.createMappingFile(experiment);
                stopWatch.stop();
                if (operationLog.isInfoEnabled()) {
                    operationLog.info(String.format("Writing mapping file '%s' out took %s.", fileName, stopWatch));
                }
                response.setHeader(HEADER_KEY, String.format(HEADER_VALUE_FORMAT, fileName));
                PrintWriter writer = response.getWriter();
                writer.write(mappingFile);
                writer.flush();
                writer.close();
            } else {
                String[] codes = new String[]{experimentCode, projectCode};
                operationLog.warn(String.format(BLANK_PARAMETERS, Arrays.asList(PARAMETERS), Arrays.asList(codes)));
            }
        }
        catch (UserFailureException ex) {
            operationLog.error(String.format("Getting experiment mapping file for experiment %s failed.", ExperimentMappingFileDownloadServlet.getExperimentDescription(projectCode, experimentCode)), (Throwable)((Object)ex));
            throw new ServletException((Throwable)((Object)ex));
        }
    }
}

