/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.server;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.base.LogMessageProvider;
import ch.systemsx.cisd.lims.server.business.Session;
import org.apache.log4j.Logger;

public class LoggerUtils {
    public static final boolean SUCCESS = true;
    public static final boolean FAILURE = false;

    private static void logUserBehaviour(LogCategory category, String message) {
        Logger logger = LogFactory.getLogger(category);
        logger.info(message);
    }

    public static LogMessageProvider createLogger(String username, String groupCode, boolean invocationSuccessful) {
        return new LogMessageProvider(username, groupCode, invocationSuccessful);
    }

    public static LogMessageProvider createLogger(Session session, boolean invocationSuccessful) {
        String username = null;
        String group = null;
        if (session != null) {
            username = session.getUserName();
            group = session.getGroupCode();
        }
        return LoggerUtils.createLogger(username, group, invocationSuccessful);
    }

    public static void logAccessUserBehaviour(String message) {
        LoggerUtils.logUserBehaviour(LogCategory.ACCESS, message);
    }

    public static void logTrackingUserBehaviour(String message) {
        LoggerUtils.logUserBehaviour(LogCategory.TRACKING, message);
    }

    public static void logAuthUserBehaviour(String message) {
        LoggerUtils.logUserBehaviour(LogCategory.AUTH, message);
    }
}

