/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.server;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.authentication.Principal;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.server.IRequestContextProvider;
import ch.systemsx.cisd.lims.base.server.RequestContextProviderAdapter;
import ch.systemsx.cisd.lims.server.business.ISessionManager;
import ch.systemsx.cisd.lims.server.business.LoginLogManager;
import ch.systemsx.cisd.lims.server.business.ParameterChecker;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.dto.GroupDTO;
import ch.systemsx.cisd.lims.webclient.server.LoggerUtils;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public final class ServletBasedSessionManager
implements ISessionManager {
    public static final String LIMS_SESSION_ATTRIBUTE_NAME = "limsSession";
    private final IAuthenticationService authenticationService;
    private final int sessionExpirationPeriodSeconds;
    private final LoginLogManager loginLogManager;
    private final IRequestContextProvider httpObjectProvider;

    public ServletBasedSessionManager(IAuthenticationService authenticationService, IRequestContextProvider requestContextProvider, int sessionExpirationPeriodMinutes) {
        this.authenticationService = authenticationService;
        this.sessionExpirationPeriodSeconds = sessionExpirationPeriodMinutes * 60;
        this.httpObjectProvider = requestContextProvider;
        this.loginLogManager = new LoginLogManager(this.getClass(), new RequestContextProviderAdapter(requestContextProvider));
    }

    private final String createAndStoreSession(String user, GroupDTO group, long now, Principal principal) {
        HttpSession httpSession = this.getHttpSession(true);
        Session session = new Session(user, httpSession.getId(), principal, group, now);
        httpSession.setMaxInactiveInterval(this.sessionExpirationPeriodSeconds);
        httpSession.setAttribute(LIMS_SESSION_ATTRIBUTE_NAME, (Object)session);
        return httpSession.getId();
    }

    private final HttpSession getHttpSession(boolean create) {
        return this.httpObjectProvider.getHttpServletRequest().getSession(create);
    }

    public final String getRemoteHost() {
        return this.httpObjectProvider.getHttpServletRequest().getRemoteHost();
    }

    public final void closeSession(String sessionToken) {
        HttpSession httpSession = this.getHttpSession(false);
        Session session = null;
        if (httpSession != null) {
            session = (Session)httpSession.getAttribute(LIMS_SESSION_ATTRIBUTE_NAME);
            httpSession.removeAttribute(LIMS_SESSION_ATTRIBUTE_NAME);
            httpSession.invalidate();
        }
        if (session != null) {
            LoggerUtils.logAuthUserBehaviour(LoggerUtils.createLogger(session.getUserName(), session.getGroupCode(), true).logout(session.getSessionStart()));
        }
        this.loginLogManager.logAttemptCloseSession(session == null ? null : session.getSessionToken(), session);
    }

    public final Session getSession(String sessionToken) throws UserFailureException {
        HttpSession httpSession = this.getHttpSession(false);
        if (httpSession == null) {
            return null;
        }
        Session session = (Session)httpSession.getAttribute(LIMS_SESSION_ATTRIBUTE_NAME);
        if (session == null) {
            String msg = "Attempt to get non-existent session from host '" + this.getRemoteHost() + "': user is not logged in.";
            Logger authenticationLog = this.loginLogManager.getAuthenticationLog();
            if (authenticationLog.isInfoEnabled()) {
                authenticationLog.info(msg);
            }
            throw new InvalidSessionException(msg);
        }
        return session;
    }

    public final String openSession(String user, String password, GroupDTO group) {
        String applicationToken;
        String groupCode;
        block6: {
            ParameterChecker.checkIfNotBlank(user, "user");
            ParameterChecker.checkIfNotBlank(password, "password");
            groupCode = group == null ? null : group.getCode();
            try {
                applicationToken = this.authenticationService.authenticateApplication();
                if (applicationToken != null) break block6;
                this.loginLogManager.getAuthenticationLog().error("User '" + user + "' failed to authenticate: application not authenticated.");
                return null;
            }
            catch (RuntimeException ex) {
                LoggerUtils.logAuthUserBehaviour(LoggerUtils.createLogger(user, groupCode, false).login());
                this.loginLogManager.logCreateSessionFailure(user, ex);
                throw ex;
            }
        }
        String sessionToken = null;
        long now = System.currentTimeMillis();
        boolean isAuthenticated = this.authenticationService.authenticateUser(applicationToken, user, password);
        if (isAuthenticated) {
            try {
                Principal principal = this.authenticationService.getPrincipal(applicationToken, user);
                sessionToken = this.createAndStoreSession(user, group, now, principal);
            }
            catch (IllegalArgumentException ex) {
                throw new EnvironmentFailureException(ex.getMessage());
            }
        }
        this.loginLogManager.logAttemptCreateSession(user, isAuthenticated, sessionToken);
        LoggerUtils.logAuthUserBehaviour(LoggerUtils.createLogger(user, groupCode, isAuthenticated).login());
        return sessionToken;
    }
}

