/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webservice;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.BaseExperiment;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ExternalData;
import ch.systemsx.cisd.lims.base.IETLLIMSService;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.base.server.IRequestContextProvider;
import ch.systemsx.cisd.lims.server.business.DomainModel;
import ch.systemsx.cisd.lims.server.business.IExperimentManager;
import ch.systemsx.cisd.lims.server.business.ISampleManager;
import ch.systemsx.cisd.lims.server.business.ISessionManager;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.webservice.AbstractLIMSService;
import ch.systemsx.cisd.lims.webservice.IAccessController;

public final class ETLLIMSService
extends AbstractLIMSService
implements IETLLIMSService {
    public ETLLIMSService(ISessionManager sessionManager, IRequestContextProvider requestContextProvider, IAccessController accessController, DomainModel domainModel, String groupCode) {
        super(sessionManager, requestContextProvider, accessController, domainModel, groupCode);
    }

    public BaseExperiment getBaseExperiment(String sessionToken, ExperimentIdentifier experimentIdentifierOrNull, String sampleCode) throws UserFailureException {
        this.checkAccess(sessionToken);
        IExperimentManager experimentManager = this.domainModel.getExperimentManager();
        return experimentManager.tryGetBaseExperiment(this.getSession(sessionToken), experimentIdentifierOrNull, sampleCode);
    }

    public SimpleEntityProperty[] tryToGetPropertiesOfTopSampleRegisteredFor(String sessionToken, String sampleCode) throws UserFailureException {
        this.checkAccess(sessionToken);
        ISampleManager sampleManager = this.domainModel.getSampleManager();
        Session session = this.getSession(sessionToken);
        return sampleManager.tryToGetPropertiesOfTopSampleRegisteredFor(session, sampleCode);
    }

    public final String registerDataSet(String sessionToken, ExperimentIdentifier experimentIdentifierOrNull, String sampleCode, String procedureTypeCode, ExternalData data) throws UserFailureException {
        this.checkAccess(sessionToken);
        ISampleManager dataSetManager = this.domainModel.getSampleManager();
        return dataSetManager.registerDataSet(this.getSession(sessionToken), experimentIdentifierOrNull, sampleCode, procedureTypeCode, data);
    }
}

