/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.process;

import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.concurrent.ExecutionResult;
import ch.systemsx.cisd.common.concurrent.ExecutionStatus;
import ch.systemsx.cisd.common.concurrent.NamedCallable;
import ch.systemsx.cisd.common.concurrent.NamingThreadPoolExecutor;
import ch.systemsx.cisd.common.exceptions.StopException;
import ch.systemsx.cisd.common.process.ProcessResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessExecutionHelper {
    public static final OutputReadingStrategy DEFAULT_OUTPUT_READING_STRATEGY = OutputReadingStrategy.ON_ERROR;
    public static final long NO_TIMEOUT = -1L;
    private static final long SHORT_TIMEOUT = 100L;
    private static final long IMMEDIATE_TIMEOUT = 0L;
    private static final ExecutorService executor = new NamingThreadPoolExecutor("osproc", 10);
    private static final AtomicInteger processCounter = new AtomicInteger();
    private final Logger operationLog;
    private final Logger machineLog;
    private final List<String> commandLine;
    private final long millisToWaitForCompletion;
    private final OutputReadingStrategy outputReadingStrategy;
    private final int processNumber = processCounter.getAndIncrement();
    private final AtomicReference<Process> processWrapper;

    public static boolean runAndLog(List<String> cmd, Logger operationLog, Logger machineLog) throws StopException {
        return new ProcessExecutionHelper(cmd, -1L, DEFAULT_OUTPUT_READING_STRATEGY, operationLog, machineLog).runAndLog();
    }

    public static ProcessResult run(List<String> cmd, Logger operationLog, Logger machineLog) throws StopException {
        return new ProcessExecutionHelper(cmd, -1L, DEFAULT_OUTPUT_READING_STRATEGY, operationLog, machineLog).run(true);
    }

    public static boolean runAndLog(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion) throws StopException {
        return new ProcessExecutionHelper(cmd, millisToWaitForCompletion, DEFAULT_OUTPUT_READING_STRATEGY, operationLog, machineLog).runAndLog();
    }

    public static ProcessResult run(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion) throws StopException {
        return new ProcessExecutionHelper(cmd, millisToWaitForCompletion, DEFAULT_OUTPUT_READING_STRATEGY, operationLog, machineLog).run(true);
    }

    public static boolean runAndLog(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion, OutputReadingStrategy outputReadingStrategy) throws StopException {
        return new ProcessExecutionHelper(cmd, millisToWaitForCompletion, outputReadingStrategy, operationLog, machineLog).runAndLog();
    }

    public static ProcessResult run(List<String> cmd, Logger operationLog, Logger machineLog, long millisToWaitForCompletion, OutputReadingStrategy outputReadingStrategy, boolean stopOnInterrupt) throws StopException {
        return new ProcessExecutionHelper(cmd, millisToWaitForCompletion, outputReadingStrategy, operationLog, machineLog).run(stopOnInterrupt);
    }

    static String getCommandName(List<String> commandLine) {
        return new File(commandLine.get(0)).getName();
    }

    private static String getCommand(List<String> commandLine) {
        return StringUtils.join(commandLine, (char)' ');
    }

    private static List<String> readProcessOutputLines(Process process, Logger machineLog, boolean wait) {
        assert (process != null);
        assert (machineLog != null);
        ArrayList<String> processOutput = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        try {
            try {
                while (wait || reader.ready()) {
                    String line = reader.readLine();
                    if (line == null) {
                        break;
                    }
                    processOutput.add(line);
                }
            }
            catch (IOException e) {
                machineLog.warn((Object)String.format("IOException when reading stdout/stderr, msg='%s'.", e.getMessage()));
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        return processOutput;
    }

    private ProcessExecutionHelper(List<String> commandLine, long millisToWaitForCompletion, OutputReadingStrategy outputReadingStrategy, Logger operationLog, Logger machineLog) {
        this.operationLog = operationLog;
        this.machineLog = machineLog;
        this.millisToWaitForCompletion = millisToWaitForCompletion == 0L ? -1L : millisToWaitForCompletion;
        this.outputReadingStrategy = outputReadingStrategy;
        this.commandLine = Collections.unmodifiableList(commandLine);
        this.processWrapper = new AtomicReference();
    }

    private ProcessResult run(boolean stopOnInterrupt) {
        Future<ProcessResult> killerFuture;
        Future<ProcessResult> runnerFuture = executor.submit(new ProcessRunner());
        ExecutionResult<ProcessResult> result = ConcurrencyUtilities.getResult(runnerFuture, this.millisToWaitForCompletion, false, null, null);
        if (result.getStatus() == ExecutionStatus.TIMED_OUT && (result = ConcurrencyUtilities.getResult(killerFuture = executor.submit(new ProcessKiller()), 100L)).tryGetResult() == null) {
            result = ConcurrencyUtilities.getResult(runnerFuture, 0L);
        }
        if (result.tryGetResult() != null) {
            return result.tryGetResult();
        }
        if (stopOnInterrupt && ExecutionStatus.INTERRUPTED.equals((Object)result.getStatus())) {
            throw new StopException();
        }
        return new ProcessResult(this.commandLine, this.processNumber, result.getStatus(), ProcessExecutionHelper.tryGetStartupFailureMessage(result.tryGetException()), -1, null, this.operationLog, this.machineLog);
    }

    private static String tryGetStartupFailureMessage(Throwable throwableOrNull) {
        if (throwableOrNull != null && throwableOrNull instanceof IOException) {
            return throwableOrNull.getMessage();
        }
        return null;
    }

    private boolean runAndLog() throws StopException {
        ProcessResult result = this.run(false);
        result.log();
        if (result.isInterruped()) {
            throw new StopException();
        }
        return result.isOK();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OutputReadingStrategy {
        NEVER,
        ON_ERROR,
        ALWAYS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProcessKiller
    implements NamedCallable<ProcessResult> {
        private ProcessKiller() {
        }

        @Override
        public ProcessResult call() {
            Process process = ProcessExecutionHelper.this.processWrapper.getAndSet(null);
            if (process != null) {
                List processOutput = null;
                if (!OutputReadingStrategy.NEVER.equals((Object)ProcessExecutionHelper.this.outputReadingStrategy)) {
                    processOutput = ProcessExecutionHelper.readProcessOutputLines(process, ProcessExecutionHelper.this.machineLog, false);
                }
                process.destroy();
                if (ProcessExecutionHelper.this.machineLog.isInfoEnabled()) {
                    ProcessExecutionHelper.this.machineLog.info((Object)(String.valueOf(String.format("Killed '" + ProcessExecutionHelper.getCommand(ProcessExecutionHelper.this.commandLine), new Object[0])) + "'."));
                }
                int exitValue = this.getExitValue(process);
                return new ProcessResult(ProcessExecutionHelper.this.commandLine, ProcessExecutionHelper.this.processNumber, ExecutionStatus.TIMED_OUT, "", exitValue, processOutput, ProcessExecutionHelper.this.operationLog, ProcessExecutionHelper.this.machineLog);
            }
            return null;
        }

        private int getExitValue(Process process) {
            try {
                return process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return -1;
            }
        }

        @Override
        public String getCallableName() {
            return "kill-P" + ProcessExecutionHelper.this.processNumber + "-{" + ProcessExecutionHelper.getCommandName(ProcessExecutionHelper.this.commandLine) + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProcessRunner
    implements NamedCallable<ProcessResult> {
        private ProcessRunner() {
        }

        private Process launch() throws IOException {
            ProcessBuilder processBuilder = new ProcessBuilder(ProcessExecutionHelper.this.commandLine);
            processBuilder.redirectErrorStream(true);
            if (ProcessExecutionHelper.this.operationLog.isDebugEnabled()) {
                ProcessExecutionHelper.this.operationLog.debug((Object)("Running command: " + ProcessExecutionHelper.getCommand(ProcessExecutionHelper.this.commandLine)));
            }
            Process process = processBuilder.start();
            return process;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ProcessResult call() throws Exception {
            try {
                Process process = this.launch();
                try {
                    ProcessExecutionHelper.this.processWrapper.set(process);
                    int exitValue = process.waitFor();
                    if (ProcessExecutionHelper.this.processWrapper.getAndSet(null) == null) {
                        return null;
                    }
                    List processOutput = null;
                    if (OutputReadingStrategy.ALWAYS.equals((Object)ProcessExecutionHelper.this.outputReadingStrategy) || OutputReadingStrategy.ON_ERROR.equals((Object)ProcessExecutionHelper.this.outputReadingStrategy) && !ProcessResult.isProcessOK(exitValue)) {
                        processOutput = ProcessExecutionHelper.readProcessOutputLines(process, ProcessExecutionHelper.this.machineLog, true);
                    }
                    ProcessResult processResult = new ProcessResult(ProcessExecutionHelper.this.commandLine, ProcessExecutionHelper.this.processNumber, ExecutionStatus.COMPLETE, "", exitValue, processOutput, ProcessExecutionHelper.this.operationLog, ProcessExecutionHelper.this.machineLog);
                    return processResult;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)process.getErrorStream());
                    IOUtils.closeQuietly((InputStream)process.getInputStream());
                    IOUtils.closeQuietly((OutputStream)process.getOutputStream());
                }
            }
            catch (Exception ex) {
                ProcessExecutionHelper.this.machineLog.error((Object)("Exception when launching: " + ex.getMessage()));
                throw ex;
            }
        }

        @Override
        public String getCallableName() {
            return "run-P" + ProcessExecutionHelper.this.processNumber + "-{" + ProcessExecutionHelper.getCommandName(ProcessExecutionHelper.this.commandLine) + "}";
        }
    }
}

