/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.MasqueradingException;
import ch.systemsx.cisd.common.utilities.ClassUtils;

public final class ExceptionUtils {
    private static final String[] ACCEPTED_PACKAGE_NAME_DEPENDENCIES = new String[]{"java.lang", "ch.systemsx.cisd"};

    ExceptionUtils() {
    }

    private static final Exception createMasqueradingException(Exception exception) {
        Exception rootException = CheckedExceptionTunnel.unwrapIfNecessary(exception);
        if (ExceptionUtils.isCandidateForMasquerading(rootException)) {
            return new MasqueradingException(rootException);
        }
        return rootException;
    }

    private static final void copyCauseException(Exception fromException, Exception toException) {
        assert (fromException != null) : "Unspecified 'from' Exception.";
        assert (toException != null) : "Unspecified 'to' Exception.";
        Exception fromCauseException = (Exception)org.apache.commons.lang.exception.ExceptionUtils.getCause((Throwable)fromException);
        if (fromCauseException != null && fromCauseException != fromException) {
            Exception toCauseException = ExceptionUtils.createMasqueradingException(fromCauseException);
            if (toException.getCause() != toCauseException && !ClassUtils.setFieldValue(toException, "cause", toCauseException)) {
                org.apache.commons.lang.exception.ExceptionUtils.setCause((Throwable)toException, (Throwable)toCauseException);
            }
            ExceptionUtils.copyCauseException(fromCauseException, toCauseException);
        }
    }

    static final boolean isCandidateForMasquerading(Exception exception) {
        assert (exception != null) : "Unspecified exception.";
        String className = exception.getClass().getName();
        String[] stringArray = ACCEPTED_PACKAGE_NAME_DEPENDENCIES;
        int n = ACCEPTED_PACKAGE_NAME_DEPENDENCIES.length;
        int n2 = 0;
        while (n2 < n) {
            String packageName = stringArray[n2];
            if (className.startsWith(packageName)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final Exception createMasqueradingExceptionIfNeeded(Exception exception) {
        assert (exception != null) : "Unspecified SQL Exception.";
        Exception clientSafeException = ExceptionUtils.createMasqueradingException(exception);
        ExceptionUtils.copyCauseException(exception, clientSafeException);
        return clientSafeException;
    }
}

