/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.utilities;

import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.lang.math.NumberUtils;

public final class PropertyUtils {
    static final String EMPTY_STRING_FORMAT = "Property '%s' is an empty string.";
    static final String NON_BOOLEAN_VALUE_FORMAT = "Invalid boolean '%s'. Default value '%s' will be used.";
    static final String NON_CHAR_VALUE_FORMAT = "Invalid character '%s' (incorrect length). Default value '%s' will be used.";
    static final String NON_INT_VALUE_FORMAT = "Invalid integer '%s'. Default value '%s' will be used.";
    static final String NOT_POSITIVE_INT_VALUE_FORMAT = "Invalid positive integer '%s'. Default value '%s' will be used.";
    static final String NON_LONG_VALUE_FORMAT = "Invalid long '%s'. Default value '%s' will be used.";
    static final String NOT_POSITIVE_LONG_VALUE_FORMAT = "Invalid positive long '%s'. Default value '%s' will be used.";
    static final String NOT_FOUND_PROPERTY_FORMAT = "Given key '%s' not found in properties '%s'";

    private PropertyUtils() {
    }

    private static void assertParameters(Properties properties, String propertyKey) {
        assert (properties != null) : "Given properties can not be null.";
        assert (propertyKey != null) : "Given property key can not be null.";
    }

    public static final String getMandatoryProperty(Properties properties, String propertyKey) throws ConfigurationFailureException {
        PropertyUtils.assertParameters(properties, propertyKey);
        String property = properties.getProperty(propertyKey);
        if (property == null) {
            throw ConfigurationFailureException.fromTemplate(NOT_FOUND_PROPERTY_FORMAT, propertyKey, CollectionUtils.abbreviate((Collection)Collections.list(properties.propertyNames()), 10));
        }
        if ((property = property.trim()).length() == 0) {
            throw ConfigurationFailureException.fromTemplate(EMPTY_STRING_FORMAT, propertyKey);
        }
        return property;
    }

    public static final long getLong(Properties properties, String propertyKey, long defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String longOrNull = properties.getProperty(propertyKey);
        if (longOrNull == null) {
            return defaultValue;
        }
        if (!NumberUtils.isNumber((String)longOrNull)) {
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.INFO, String.format(NON_LONG_VALUE_FORMAT, longOrNull, defaultValue));
            }
            return defaultValue;
        }
        return NumberUtils.createNumber((String)longOrNull).longValue();
    }

    public static final long getLong(Properties properties, String propertyKey, long defaultValue) {
        return PropertyUtils.getLong(properties, propertyKey, defaultValue, null);
    }

    public static final long getPosLong(Properties properties, String propertyKey, long defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        assert (defaultValue > -1L) : "Negative default value (< 0).";
        String longOrNull = properties.getProperty(propertyKey);
        if (longOrNull == null) {
            return defaultValue;
        }
        if (!NumberUtils.isDigits((String)longOrNull)) {
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.INFO, String.format(NON_LONG_VALUE_FORMAT, longOrNull, defaultValue));
            }
            return defaultValue;
        }
        return Long.parseLong(longOrNull);
    }

    public static final long getPosLong(Properties properties, String propertyKey, long defaultValue) {
        return PropertyUtils.getPosLong(properties, propertyKey, defaultValue, null);
    }

    public static final int getInt(Properties properties, String propertyKey, int defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String intOrNull = properties.getProperty(propertyKey);
        if (intOrNull == null) {
            return defaultValue;
        }
        if (!NumberUtils.isNumber((String)intOrNull)) {
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.INFO, String.format(NON_INT_VALUE_FORMAT, intOrNull, defaultValue));
            }
            return defaultValue;
        }
        return NumberUtils.createNumber((String)intOrNull).intValue();
    }

    public static final int getInt(Properties properties, String propertyKey, int defaultValue) {
        return PropertyUtils.getInt(properties, propertyKey, defaultValue, null);
    }

    public static final int getPosInt(Properties properties, String propertyKey, int defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        assert (defaultValue > -1) : "Negative default value (< 0).";
        String intOrNull = properties.getProperty(propertyKey);
        if (intOrNull == null) {
            return defaultValue;
        }
        if (!NumberUtils.isDigits((String)intOrNull)) {
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.INFO, String.format(NON_INT_VALUE_FORMAT, intOrNull, defaultValue));
            }
            return defaultValue;
        }
        return Integer.parseInt(intOrNull);
    }

    public static final int getPosInt(Properties properties, String propertyKey, int defaultValue) {
        return PropertyUtils.getPosInt(properties, propertyKey, defaultValue, null);
    }

    public static final boolean getBoolean(Properties properties, String propertyKey, boolean defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String booleanOrNull = properties.getProperty(propertyKey);
        if (booleanOrNull == null) {
            return defaultValue;
        }
        Boolean bool = Boolean.getBoolean(booleanOrNull);
        if (bool == null) {
            if (loggerOrNull != null) {
                loggerOrNull.log(LogLevel.INFO, String.format(NON_BOOLEAN_VALUE_FORMAT, booleanOrNull, defaultValue));
            }
            return defaultValue;
        }
        return Boolean.toBoolean(bool);
    }

    public static final char getChar(Properties properties, String propertyKey, char defaultValue) {
        return PropertyUtils.getChar(properties, propertyKey, defaultValue, null);
    }

    public static final char getChar(Properties properties, String propertyKey, char defaultValue, ISimpleLogger loggerOrNull) {
        PropertyUtils.assertParameters(properties, propertyKey);
        String charOrNull = properties.getProperty(propertyKey);
        if (charOrNull == null) {
            return defaultValue;
        }
        if (charOrNull.length() != 1 && loggerOrNull != null) {
            loggerOrNull.log(LogLevel.INFO, String.format(NON_CHAR_VALUE_FORMAT, charOrNull, Character.valueOf(defaultValue)));
            return defaultValue;
        }
        return charOrNull.charAt(0);
    }

    public static final boolean getBoolean(Properties properties, String propertyKey, boolean defaultValue) {
        return PropertyUtils.getBoolean(properties, propertyKey, defaultValue, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Boolean {
        TRUE("1", "yes", "true"),
        FALSE("0", "no", "false");

        private final String[] values;

        private Boolean(String ... values) {
            this.values = values;
        }

        public static final Boolean getBoolean(String value) {
            if (Boolean.contains(Boolean.TRUE.values, value)) {
                return TRUE;
            }
            if (Boolean.contains(Boolean.FALSE.values, value)) {
                return FALSE;
            }
            return null;
        }

        public static final boolean toBoolean(Boolean bool) {
            return bool == TRUE;
        }

        private static final boolean contains(String[] values, String value) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (string.equalsIgnoreCase(value)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

