/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.datasetdownload;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.lims.base.RMIBasedLIMSServiceFactory;
import ch.systemsx.cisd.lims.base.ServiceRegistry;
import ch.systemsx.cisd.openbis.datasetdownload.ApplicationContext;
import ch.systemsx.cisd.openbis.datasetdownload.ConfigParameters;
import ch.systemsx.cisd.openbis.datasetdownload.DataSetService;
import ch.systemsx.cisd.openbis.datasetdownload.DatasetDownloadServlet;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;

public class DatasetDownloadService {
    static final String APPLICATION_CONTEXT_KEY = "application-context";
    private static final String PREFIX = "data-set-download.";
    private static final int PREFIX_LENGTH = "data-set-download.".length();
    private static final String SERVICE_PROPERTIES_FILE = "etc/service.properties";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DatasetDownloadService.class);

    public static void main(String[] args) throws Exception {
        LogInitializer.init();
        ServiceRegistry.setLIMSServiceFactory(RMIBasedLIMSServiceFactory.INSTANCE);
        ApplicationContext applicationContext = DatasetDownloadService.createApplicationContext();
        ConfigParameters configParameters = applicationContext.getConfigParameters();
        int port = configParameters.getPort();
        Server server = new Server();
        SslSocketConnector socketConnector = new SslSocketConnector();
        socketConnector.setPort(port);
        socketConnector.setMaxIdleTime(30000);
        socketConnector.setKeystore(configParameters.getKeystorePath());
        socketConnector.setPassword(configParameters.getKeystorePassword());
        socketConnector.setKeyPassword(configParameters.getKeystoreKeyPassword());
        server.addConnector(socketConnector);
        Context context = new Context(server, "/", 1);
        context.setAttribute(APPLICATION_CONTEXT_KEY, applicationContext);
        context.addServlet(DatasetDownloadServlet.class, "/" + applicationContext.getApplicationName() + "/*");
        server.start();
        DatasetDownloadService.selfTest(applicationContext);
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("Data set download server ready on port " + port));
        }
    }

    private static void selfTest(ApplicationContext applicationContext) {
        int version = applicationContext.getDataSetService().getVersion();
        if (18 != version) {
            throw new ConfigurationFailureException("This client has the wrong service version for the server (client: 18, server: " + version + ").");
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("openBIS service (interface version " + version + ") is reachable"));
        }
    }

    private static ApplicationContext createApplicationContext() {
        ConfigParameters configParameters = DatasetDownloadService.getConfigParameters();
        DataSetService dataSetService = new DataSetService(configParameters);
        ApplicationContext applicationContext = new ApplicationContext(dataSetService, configParameters, "dataset-download");
        return applicationContext;
    }

    private static ConfigParameters getConfigParameters() {
        Properties properties = DatasetDownloadService.loadProperties();
        Properties systemProperties = System.getProperties();
        Enumeration<?> propertyNames = systemProperties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            if (!name.startsWith(PREFIX)) continue;
            String value = systemProperties.getProperty(name);
            properties.setProperty(name.substring(PREFIX_LENGTH), value);
        }
        return new ConfigParameters(properties);
    }

    private static Properties loadProperties() {
        Properties properties;
        Properties properties2 = new Properties();
        FileInputStream is = new FileInputStream(SERVICE_PROPERTIES_FILE);
        try {
            properties2.load(is);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)is);
                throw throwable;
            }
            catch (Exception ex) {
                operationLog.warn((Object)"Could not load the service properties from resource 'etc/service.properties'.", (Throwable)ex);
                throw new ConfigurationFailureException("Could not load the service properties from resource 'etc/service.properties'.", ex);
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return properties;
    }
}

