/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.datasetdownload;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.lims.base.ExternalData;
import ch.systemsx.cisd.lims.base.IDataSetService;
import ch.systemsx.cisd.lims.base.LocatorType;
import ch.systemsx.cisd.openbis.datasetdownload.ApplicationContext;
import ch.systemsx.cisd.openbis.datasetdownload.ConfigParameters;
import ch.systemsx.cisd.openbis.datasetdownload.HTMLRendererFactory;
import ch.systemsx.cisd.openbis.datasetdownload.IDirectoryRenderer;
import ch.systemsx.cisd.openbis.datasetdownload.IErrorRenderer;
import ch.systemsx.cisd.openbis.datasetdownload.IRendererFactory;
import ch.systemsx.cisd.openbis.datasetdownload.PlainTextRendererFactory;
import ch.systemsx.cisd.openbis.datasetdownload.RenderingContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasetDownloadServlet
extends HttpServlet {
    private static final String TEXT_MODE_DISPLAY = "txt";
    static final String DATA_SET_KEY = "data-set";
    static final String DATASET_CODE_KEY = "dataSetCode";
    static final String SESSION_ID_KEY = "sessionID";
    static final String DISPLAY_MODE_KEY = "mode";
    static final String BINARY_CONTENT_TYPE = "binary";
    private static final long serialVersionUID = 1L;
    protected static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DatasetDownloadServlet.class);
    protected static final Logger notificationLog = LogFactory.getLogger(LogCategory.NOTIFY, DatasetDownloadServlet.class);
    private static final Comparator<File> FILE_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File file1, File file2) {
            return this.createSortableName(file1).compareTo(this.createSortableName(file2));
        }

        private String createSortableName(File file) {
            return String.valueOf(file.isDirectory() ? "D" : "F") + file.getName().toUpperCase();
        }
    };
    private ApplicationContext applicationContext;

    public DatasetDownloadServlet() {
    }

    DatasetDownloadServlet(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public final void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            ServletContext context = servletConfig.getServletContext();
            this.applicationContext = (ApplicationContext)context.getAttribute("application-context");
        }
        catch (Exception ex) {
            notificationLog.fatal((Object)("Failure during '" + servletConfig.getServletName() + "' servlet initialization."), (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        IRendererFactory rendererFactory = null;
        try {
            RequestParams requestParams = DatasetDownloadServlet.parseRequestURL(request, this.applicationContext.getApplicationName());
            rendererFactory = this.createRendererFactory(requestParams.isPlainTextMode());
            this.obtainDataSetFromServer(requestParams.getDataSetCode(), requestParams.tryGetSessionId(), request);
            HttpSession session = request.getSession(false);
            if (session == null) {
                this.printSessionExpired(response);
            } else {
                this.printResponse(response, rendererFactory, requestParams, session);
            }
        }
        catch (Exception e) {
            if (rendererFactory == null) {
                rendererFactory = new PlainTextRendererFactory();
            }
            this.printError(rendererFactory, request, response, e);
        }
    }

    private void printResponse(HttpServletResponse response, IRendererFactory rendererFactory, RequestParams requestParams, HttpSession session) throws UnsupportedEncodingException, IOException {
        String dataSetCode = requestParams.getDataSetCode();
        ExternalData dataSet = this.tryToGetDataSet(session, dataSetCode);
        if (dataSet == null) {
            throw new UserFailureException("Unknown data set '" + dataSetCode + "'.");
        }
        File rootDir = this.createDataSetRootDirectory(dataSet);
        RenderingContext context = new RenderingContext(rootDir, requestParams.getURLPrefix(), requestParams.getPathInfo());
        this.renderPage(rendererFactory, response, dataSet, context);
    }

    private IRendererFactory createRendererFactory(boolean plainTextMode) {
        if (plainTextMode) {
            return new PlainTextRendererFactory();
        }
        return new HTMLRendererFactory();
    }

    private static RequestParams parseRequestURL(HttpServletRequest request, String applicationName) throws UnsupportedEncodingException {
        String pathInfo;
        String dataSetCode;
        String urlPrefix = "/" + applicationName + "/";
        String requestURI = URLDecoder.decode(request.getRequestURI(), "UTF-8");
        if (!requestURI.startsWith(urlPrefix)) {
            throw new EnvironmentFailureException("Request URI '" + requestURI + "' expected to start with '" + urlPrefix + "'.");
        }
        String fullPathInfo = requestURI.substring(urlPrefix.length());
        int indexOfFirstSeparator = fullPathInfo.indexOf(47);
        if (indexOfFirstSeparator < 0) {
            dataSetCode = fullPathInfo;
            pathInfo = "";
        } else {
            dataSetCode = fullPathInfo.substring(0, indexOfFirstSeparator);
            pathInfo = fullPathInfo.substring(indexOfFirstSeparator + 1);
        }
        String urlPrefixWithDataset = requestURI.substring(0, requestURI.length() - pathInfo.length());
        String sessionIDOrNull = request.getParameter(SESSION_ID_KEY);
        String displayMode = request.getParameter(DISPLAY_MODE_KEY);
        boolean isTextMode = displayMode != null && displayMode.equals(TEXT_MODE_DISPLAY);
        return new RequestParams(dataSetCode, pathInfo, sessionIDOrNull, urlPrefixWithDataset, isTextMode);
    }

    private void printError(IRendererFactory rendererFactory, HttpServletRequest request, HttpServletResponse response, Exception exception) throws IOException {
        if (!(exception instanceof UserFailureException)) {
            StringBuffer url = request.getRequestURL();
            String queryString = request.getQueryString();
            if (StringUtils.isNotBlank((String)queryString)) {
                url.append("?").append(queryString);
            }
            operationLog.error((Object)("Request " + url + " caused an exception: "), (Throwable)exception);
        } else if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("User failure: " + exception.getMessage()));
        }
        String message = exception.getMessage();
        String errorText = StringUtils.isBlank((String)message) ? exception.toString() : message;
        IErrorRenderer errorRenderer = rendererFactory.createErrorRenderer();
        response.setContentType(rendererFactory.getContentType());
        PrintWriter writer = response.getWriter();
        errorRenderer.setWriter(writer);
        errorRenderer.printErrorMessage(errorText);
        writer.flush();
        writer.close();
    }

    private void renderPage(IRendererFactory rendererFactory, HttpServletResponse response, ExternalData dataSet, RenderingContext renderingContext) throws IOException {
        File file = renderingContext.getFile();
        if (!file.exists()) {
            throw new EnvironmentFailureException("File '" + file.getName() + "' does not exist.");
        }
        if (file.isDirectory()) {
            this.createPage(rendererFactory, response, dataSet, renderingContext, file);
        } else {
            this.deliverFile(response, dataSet, file);
        }
    }

    private void createPage(IRendererFactory rendererFactory, HttpServletResponse response, ExternalData dataSet, RenderingContext renderingContext, File file) throws IOException {
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("For data set '" + dataSet.getCode() + "' show directory " + file.getAbsolutePath()));
        }
        IDirectoryRenderer directoryRenderer = rendererFactory.createDirectoryRenderer(renderingContext);
        response.setContentType(rendererFactory.getContentType());
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            directoryRenderer.setWriter(writer);
            directoryRenderer.printHeader(dataSet);
            String relativeParentPath = renderingContext.getRelativeParentPath();
            if (relativeParentPath != null) {
                directoryRenderer.printLinkToParentDirectory(relativeParentPath);
            }
            File[] children = file.listFiles();
            Arrays.sort(children, FILE_COMPARATOR);
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                String name = child.getName();
                File rootDir = renderingContext.getRootDir();
                String relativePath = FileUtilities.getRelativeFile(rootDir, child);
                String normalizedRelativePath = relativePath.replace('\\', '/');
                if (child.isDirectory()) {
                    directoryRenderer.printDirectory(name, normalizedRelativePath);
                } else {
                    directoryRenderer.printFile(name, normalizedRelativePath, child.length());
                }
                ++n2;
            }
            directoryRenderer.printFooter();
            writer.flush();
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    private void deliverFile(HttpServletResponse response, ExternalData dataSet, File file) throws IOException, FileNotFoundException {
        long size = file.length();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("For data set '" + dataSet.getCode() + "' deliver file " + file.getAbsolutePath() + " (" + size + " bytes)."));
        }
        response.setContentLength((int)size);
        response.setHeader("Content-Disposition", "inline; filename=" + file.getName());
        ServletOutputStream outputStream = null;
        FileInputStream fileInputStream = null;
        response.setContentType(BINARY_CONTENT_TYPE);
        try {
            outputStream = response.getOutputStream();
            fileInputStream = new FileInputStream(file);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)outputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileInputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    private void printSessionExpired(HttpServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        writer.write("<html><body>Download session expired.</body></html>");
        writer.flush();
        writer.close();
    }

    private void obtainDataSetFromServer(String dataSetCode, String sessionIdOrNull, HttpServletRequest request) {
        if (sessionIdOrNull != null) {
            IDataSetService dataSetService = this.applicationContext.getDataSetService();
            ExternalData dataSet = dataSetService.getDataSet(sessionIdOrNull, dataSetCode);
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)("Data set '" + dataSetCode + "' obtained from openBIS server."));
            }
            HttpSession session = request.getSession(true);
            ConfigParameters configParameters = this.applicationContext.getConfigParameters();
            session.setMaxInactiveInterval(configParameters.getSessionTimeout());
            this.putDataSetToMap(session, dataSetCode, dataSet);
        }
    }

    private File createDataSetRootDirectory(ExternalData dataSet) {
        File dataSetRootDirectory;
        String path = dataSet.getLocation();
        LocatorType locatorType = dataSet.getLocatorType();
        if (locatorType.getCode().equals("RELATIVE_LOCATION")) {
            path = String.valueOf(this.applicationContext.getConfigParameters().getStorePath()) + "/" + path;
        }
        if (!(dataSetRootDirectory = new File(path)).exists()) {
            throw new UserFailureException("Data set '" + dataSet.getCode() + "' not found in store at '" + dataSetRootDirectory.getAbsolutePath() + "'.");
        }
        return dataSetRootDirectory;
    }

    private void putDataSetToMap(HttpSession session, String dataSetCode, ExternalData dataSet) {
        this.getDataSets(session).put(dataSetCode, dataSet);
    }

    private ExternalData tryToGetDataSet(HttpSession session, String dataSetCode) {
        return this.getDataSets(session).get(dataSetCode);
    }

    private Map<String, ExternalData> getDataSets(HttpSession session) {
        HashMap map = (HashMap)session.getAttribute(DATA_SET_KEY);
        if (map == null) {
            map = new HashMap();
            session.setAttribute(DATA_SET_KEY, map);
        }
        return map;
    }

    private static class RequestParams {
        private final String dataSetCode;
        private final String pathInfo;
        private final String sessionIdOrNull;
        private final boolean isPlainTextMode;
        private final String urlPrefixWithDataset;

        public RequestParams(String dataSetCode, String pathInfo, String sessionIdOrNull, String urlPrefixWithDataset, boolean isPlainTextMode) {
            this.dataSetCode = dataSetCode;
            this.pathInfo = pathInfo;
            this.sessionIdOrNull = sessionIdOrNull;
            this.urlPrefixWithDataset = urlPrefixWithDataset;
            this.isPlainTextMode = isPlainTextMode;
        }

        public String getDataSetCode() {
            return this.dataSetCode;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        public String tryGetSessionId() {
            return this.sessionIdOrNull;
        }

        public boolean isPlainTextMode() {
            return this.isPlainTextMode;
        }

        public String getURLPrefix() {
            return this.urlPrefixWithDataset;
        }
    }
}

