/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds;

import ch.systemsx.cisd.bds.Constants;
import ch.systemsx.cisd.bds.IStorable;
import ch.systemsx.cisd.bds.StringUtils;
import ch.systemsx.cisd.bds.Utilities;
import ch.systemsx.cisd.bds.exception.DataStructureException;
import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.common.collections.CollectionIO;
import ch.systemsx.cisd.common.types.BooleanOrUnknown;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataSet
implements IStorable {
    static final String NO_PARENT_FOR_MEASURED_DATA = "No parent could be specified for measured data.";
    static final String FOLDER = "data_set";
    static final String CODE = "code";
    static final String PRODUCTION_TIMESTAMP = "production_timestamp";
    static final String PRODUCER_CODE = "producer_code";
    static final String OBSERVABLE_TYPE = "observable_type";
    static final String IS_MEASURED = "is_measured";
    static final String IS_COMPLETE = "is_complete";
    static final String PARENT_CODES = "parent_codes";
    private final Date productionTimestamp;
    private final String producerCode;
    private final String observableTypeCode;
    private final boolean isMeasured;
    private final List<String> parentCodes;
    private String code;
    private BooleanOrUnknown isComplete = BooleanOrUnknown.UNKNOWN;

    public DataSet(String code, String observableType) {
        this(code, observableType, true, null, null, null);
    }

    public DataSet(String code, String observableType, boolean isMeasured, Date productionTimestampOrNull, String producerCodeOrNull, List<String> parentCodesOrNull) {
        this.code = code == null ? "" : code;
        this.isMeasured = isMeasured;
        assert (!StringUtils.isEmpty(observableType)) : "Unspecified observable type.";
        this.observableTypeCode = observableType;
        if (isMeasured && parentCodesOrNull != null && parentCodesOrNull.size() > 0) {
            throw new IllegalArgumentException(String.format(NO_PARENT_FOR_MEASURED_DATA, new Object[0]));
        }
        this.parentCodes = parentCodesOrNull == null ? Collections.emptyList() : parentCodesOrNull;
        this.producerCode = producerCodeOrNull;
        this.productionTimestamp = productionTimestampOrNull;
    }

    public final void setCode(String code) {
        this.code = code;
    }

    public final String getCode() {
        return this.code;
    }

    public final Date getProductionTimestamp() {
        return this.productionTimestamp;
    }

    public final String getProducerCode() {
        return this.producerCode;
    }

    public final String getObservableTypeCode() {
        return this.observableTypeCode;
    }

    public final boolean isMeasured() {
        return this.isMeasured;
    }

    public final List<String> getParentCodes() {
        return this.parentCodes;
    }

    public final void setComplete(boolean complete) {
        this.isComplete = BooleanOrUnknown.resolve(complete);
    }

    static final DataSet loadFrom(IDirectory directory) {
        BooleanOrUnknown completeFlag;
        assert (directory != null) : "Given directory can not be null.";
        IDirectory idFolder = Utilities.getSubDirectory(directory, FOLDER);
        String code = Utilities.getTrimmedString(idFolder, CODE);
        String observableTypeCode = Utilities.getTrimmedString(idFolder, OBSERVABLE_TYPE);
        boolean isMeasured = Utilities.getBoolean(idFolder, IS_MEASURED);
        Date productionTimestampOrNull = Utilities.getDateOrNull(idFolder, PRODUCTION_TIMESTAMP);
        String producerCode = Utilities.getTrimmedString(idFolder, PRODUCER_CODE);
        List<String> parentCodes = Utilities.getStringList(idFolder, PARENT_CODES);
        String strIsComplete = Utilities.getTrimmedString(idFolder, IS_COMPLETE);
        try {
            completeFlag = BooleanOrUnknown.valueOf(strIsComplete);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataStructureException(String.format("'%s' value must be one of '%s' but is '%s'.", IS_COMPLETE, Arrays.asList(BooleanOrUnknown.values()), strIsComplete));
        }
        assert (completeFlag != null) : "Complete flag not specified.";
        DataSet dataSet = new DataSet(code, observableTypeCode, isMeasured, productionTimestampOrNull, producerCode.length() == 0 ? null : producerCode, parentCodes);
        dataSet.isComplete = completeFlag;
        return dataSet;
    }

    @Override
    public final void saveTo(IDirectory directory) {
        String value;
        IDirectory folder = directory.makeDirectory(FOLDER);
        folder.addKeyValuePair(CODE, this.code);
        folder.addKeyValuePair(PRODUCTION_TIMESTAMP, this.productionTimestamp == null ? "" : Constants.DATE_FORMAT.get().format(this.productionTimestamp));
        folder.addKeyValuePair(PRODUCER_CODE, StringUtils.emptyIfNull(this.producerCode));
        folder.addKeyValuePair(IS_MEASURED, Boolean.toString(this.isMeasured).toUpperCase());
        folder.addKeyValuePair(OBSERVABLE_TYPE, this.observableTypeCode);
        folder.addKeyValuePair(IS_COMPLETE, this.isComplete.toString());
        if (this.parentCodes.size() > 0) {
            StringWriter stringWriter = new StringWriter();
            CollectionIO.writeIterable(stringWriter, this.parentCodes, null);
            value = stringWriter.toString();
        } else {
            value = "";
        }
        folder.addKeyValuePair(PARENT_CODES, value);
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DataSet)) {
            return false;
        }
        DataSet that = (DataSet)obj;
        return that.code.equals(this.code);
    }

    public final int hashCode() {
        int result = 17;
        result = 37 * result + this.code.hashCode();
        return result;
    }
}

